/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo.watcher;

import com.blazebit.jbake.mojo.watcher.WatcherListener;
import com.blazebit.jbake.mojo.watcher.WatcherTimerService;
import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WatchDir {
    private static final Logger LOG = Logger.getLogger(WatchDir.class.getName());
    private static final WatchEvent.Kind<?>[] watchEventKinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW};
    private static final WatchEvent.Modifier[] watchModifiers = System.getProperty("os.name").startsWith("Windows") ? new WatchEvent.Modifier[]{ExtendedWatchEventModifier.FILE_TREE} : new WatchEvent.Modifier[0];
    private final WatcherTimerService timerService;
    private final Path rootDir;
    private final WatchService watcher;
    private final WatcherListener listener;
    private final Map<WatchKey, Path> keys;
    private final boolean recursive;
    private final boolean skipHidden;

    WatchDir(WatcherTimerService timerService, Path dir, WatcherListener listener, boolean recursive, boolean skipHidden) throws IOException {
        this.timerService = timerService;
        this.rootDir = dir;
        this.watcher = dir.getFileSystem().newWatchService();
        this.listener = listener;
        this.keys = new HashMap<WatchKey, Path>();
        this.recursive = recursive;
        this.skipHidden = skipHidden;
        if (recursive) {
            this.registerAll(dir);
        } else {
            this.register(dir);
        }
    }

    void processEvents() throws ClosedWatchServiceException {
        WatchKey key;
        while ((key = this.watcher.poll()) != null) {
            Path dir = this.keys.get(key);
            if (dir == null) {
                LOG.severe("WatchKey not recognized: " + key);
                continue;
            }
            block5: for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (StandardWatchEventKinds.OVERFLOW == kind) {
                    try {
                        this.listener.refreshQueued();
                        this.timerService.queue(this, this.listener);
                    }
                    catch (RuntimeException ex) {
                        this.logException(ex);
                    }
                    continue;
                }
                if (this.timerService.requeue(this, this.listener)) continue;
                Path name = (Path)event.context();
                if (this.skipHidden) {
                    for (int i = 0; i < name.getNameCount(); ++i) {
                        if (name.getName(i).toString().charAt(0) == '.') continue block5;
                    }
                }
                Path child = dir.resolve(name);
                try {
                    if (StandardWatchEventKinds.ENTRY_CREATE == kind) {
                        if (this.recursive && Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerRecursive(child);
                        }
                        this.listener.created(name);
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE == kind) {
                        this.listener.deleted(name);
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_MODIFY != kind) continue;
                    if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                        LOG.log(Level.FINE, "Skipped modify event for directory: " + name);
                        continue;
                    }
                    this.listener.modified(name);
                }
                catch (RuntimeException ex) {
                    this.logException(ex);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (!this.keys.isEmpty()) continue;
            break;
        }
    }

    public void close() {
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            this.logException(e);
        }
    }

    public Path getRootDir() {
        return this.rootDir;
    }

    public WatcherListener getListener() {
        return this.listener;
    }

    private void registerRecursive(Path dir) {
        if (watchModifiers.length == 0) {
            try {
                this.registerAll(dir);
            }
            catch (IOException ex) {
                this.logException(ex);
            }
        }
    }

    private void register(Path dir) throws IOException {
        if (!this.skipHidden || dir.getFileName().toString().charAt(0) != '.') {
            WatchKey key = dir.register(this.watcher, watchEventKinds, watchModifiers);
            this.keys.put(key, dir);
        }
    }

    private void registerAll(Path start) throws IOException {
        if (watchModifiers.length == 1) {
            this.register(start);
        } else {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    WatchDir.this.register(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void logException(Throwable e) {
        LOG.log(Level.SEVERE, "An error occurred in the watcher service!", e);
    }
}

