/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo.watcher;

import com.blazebit.jbake.mojo.watcher.WatchDir;
import com.blazebit.jbake.mojo.watcher.WatcherListener;
import com.blazebit.jbake.mojo.watcher.WatcherTimerService;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WatcherService
extends Thread {
    private static final Logger LOG = Logger.getLogger(WatcherService.class.getName());
    private static final long DEFAULT_SLEEP = 100L;
    private final WatcherTimerService timerService = new WatcherTimerService();
    private final List<WatchDir> watchers = new CopyOnWriteArrayList<WatchDir>();
    private volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Path path, WatcherListener listener) {
        if (!this.running) {
            return;
        }
        WatchDir watchDir = null;
        try {
            watchDir = new WatchDir(this.timerService, path, listener, true, true);
            this.watchers.add(watchDir);
        }
        catch (IOException e) {
            this.logException(e.getCause());
            this.removeListener(path, listener);
        }
        finally {
            if (!this.running && watchDir != null) {
                this.watchers.remove(watchDir);
                this.close(watchDir);
            }
        }
    }

    public void removeListener(Path path, WatcherListener listener) {
        for (WatchDir watchDir : this.watchers) {
            if (!path.equals(watchDir.getRootDir()) || !listener.equals(watchDir.getListener())) continue;
            this.watchers.remove(watchDir);
            this.close(watchDir);
            break;
        }
    }

    private void close(WatchDir watchDir) {
        watchDir.close();
    }

    public void init() {
        this.setName("WatcherService");
        this.start();
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
        for (WatchDir watchDir : this.watchers) {
            this.close(watchDir);
        }
        this.watchers.clear();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                WatcherService.sleep(100L);
                this.processEvents();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void processEvents() {
        try {
            for (WatchDir entry : this.watchers) {
                entry.processEvents();
            }
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            // empty catch block
        }
    }

    private void logException(Throwable e) {
        LOG.log(Level.SEVERE, "An error occurred in the watcher service!", e);
    }
}

