/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo.watcher;

import com.blazebit.jbake.mojo.watcher.WatchDir;
import com.blazebit.jbake.mojo.watcher.WatcherListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WatcherTimerService {
    private static final Logger LOG = Logger.getLogger(WatcherTimerService.class.getName());
    private static final long DEFAULT_TIMEOUT = 400L;
    private final Timer timer = new Timer("WatcherTimerService");
    private final ConcurrentMap<WatchDir, WatcherTimerTask> queuedRefreshTasks = new ConcurrentHashMap<WatchDir, WatcherTimerTask>();
    private volatile boolean running = true;

    public void shutdown() {
        this.running = false;
        this.timer.cancel();
        for (WatcherTimerTask task : this.queuedRefreshTasks.values()) {
            task.await();
        }
        this.queuedRefreshTasks.clear();
    }

    public void queue(WatchDir watchDir, WatcherListener listener) {
        if (!this.running) {
            return;
        }
        WatcherTimerTask task = new WatcherTimerTask(watchDir, listener);
        WatcherTimerTask previousTask = this.queuedRefreshTasks.putIfAbsent(watchDir, task);
        if (previousTask == null) {
            LOG.finest("Scheduled refresh");
            this.timer.schedule((TimerTask)task, 400L);
        } else if (previousTask.cancel()) {
            LOG.finest("Canceled and rescheduled refresh");
            this.timer.schedule((TimerTask)task, 400L);
        } else {
            LOG.finest("Additionally scheduled refresh");
            if (!this.queuedRefreshTasks.replace(watchDir, previousTask, task)) {
                this.queuedRefreshTasks.put(watchDir, task);
            }
            this.timer.schedule((TimerTask)task, 400L);
        }
    }

    public boolean requeue(WatchDir watchDir, WatcherListener listener) {
        if (!this.running) {
            return false;
        }
        WatcherTimerTask task = (WatcherTimerTask)this.queuedRefreshTasks.get(watchDir);
        if (task == null) {
            return false;
        }
        if (task.cancel()) {
            LOG.finest("Requeued refresh");
            WatcherTimerTask newTask = new WatcherTimerTask(watchDir, listener);
            if (!this.queuedRefreshTasks.replace(watchDir, task, newTask)) {
                this.queuedRefreshTasks.put(watchDir, newTask);
            }
            this.timer.schedule((TimerTask)newTask, 400L);
            return true;
        }
        LOG.finest("Awaiting refresh");
        task.await();
        LOG.finest("Awaited refresh");
        return false;
    }

    private class WatcherTimerTask
    extends TimerTask {
        private final WatchDir watchDir;
        private final WatcherListener listener;
        private final Object lock = new Object();

        public WatcherTimerTask(WatchDir watchDir, WatcherListener listener) {
            this.watchDir = watchDir;
            this.listener = listener;
        }

        @Override
        public boolean cancel() {
            boolean prevented = super.cancel();
            return prevented;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    LOG.finest("Refreshing");
                    this.listener.refresh();
                }
                catch (RuntimeException ex) {
                    this.logException(ex);
                }
                finally {
                    WatcherTimerService.this.queuedRefreshTasks.remove(this.watchDir, this);
                    LOG.finest("Refreshed");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() {
            Object object = this.lock;
            synchronized (object) {
                return;
            }
        }

        private void logException(Throwable e) {
            LOG.log(Level.SEVERE, "An error occurred in the watcher timer service!", e);
        }
    }
}

