/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource.blazegraph;

import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;

public class BigdataStatementToJenaStatementMapper
implements Map1<BigdataStatement, Statement> {
    private static BigdataStatementToJenaStatementMapper instance = null;
    public static final TypeMapper JENA_TYPE_MAPPER = TypeMapper.getInstance();

    public static BigdataStatementToJenaStatementMapper getInstance() {
        if (instance == null) {
            instance = new BigdataStatementToJenaStatementMapper();
        }
        return instance;
    }

    public Statement map1(BigdataStatement blzgStmt) {
        Resource s = this.convertToJenaResource(blzgStmt.getSubject());
        Property p = this.convertToJenaProperty((BigdataResource)blzgStmt.getPredicate());
        RDFNode o = this.convertToJenaRDFNode(blzgStmt.getObject());
        return ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o);
    }

    public Resource convertToJenaResource(BigdataResource r) {
        return ResourceFactory.createResource((String)r.stringValue());
    }

    public Property convertToJenaProperty(BigdataResource r) {
        return ResourceFactory.createProperty((String)r.stringValue());
    }

    public RDFNode convertToJenaRDFNode(BigdataValue v) {
        if (v instanceof BigdataResource) {
            return this.convertToJenaResource((BigdataResource)v);
        }
        if (!(v instanceof BigdataLiteral)) {
            throw new IllegalArgumentException(v.getClass().getName());
        }
        BigdataLiteral l = (BigdataLiteral)v;
        String lex = l.getLabel();
        BigdataURI datatypeURI = l.getDatatype();
        String languageTag = l.getLanguage();
        if (datatypeURI != null) {
            RDFDatatype dt = JENA_TYPE_MAPPER.getSafeTypeByName(datatypeURI.stringValue());
            return ResourceFactory.createTypedLiteral((String)lex, (RDFDatatype)dt);
        }
        if (languageTag != null) {
            return ResourceFactory.createLangLiteral((String)lex, (String)languageTag);
        }
        return ResourceFactory.createPlainLiteral((String)lex);
    }
}

