/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource.blazegraph;

import com.bigdata.journal.Options;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.linkeddatafragments.datasource.DataSourceBase;
import org.linkeddatafragments.datasource.IFragmentRequestProcessor;
import org.linkeddatafragments.datasource.blazegraph.BlazegraphBasedTPFRequestProcessor;
import org.linkeddatafragments.datasource.blazegraph.TPFRequestParserForBlazegraph;
import org.linkeddatafragments.exceptions.DataSourceCreationException;
import org.linkeddatafragments.fragments.IFragmentRequestParser;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class BlazegraphDataSource
extends DataSourceBase {
    protected final BigdataSailRepository repo;
    protected final boolean repoHasToBeShutDown;
    protected final AbstractTripleStore store;
    protected final BlazegraphBasedTPFRequestProcessor requestProcessor;

    public BlazegraphDataSource(String title, String description, Properties props) throws DataSourceCreationException {
        this(title, description, new BigdataSailRepository(new BigdataSail(BlazegraphDataSource.check((Properties)props, (String)title))), true);
        try {
            this.repo.initialize();
        }
        catch (Exception e) {
            throw new DataSourceCreationException((Throwable)e);
        }
        if (props.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE).equals("MemStore") && props.containsKey("file")) {
            this.loadData(props.getProperty("file"));
        }
    }

    public BlazegraphDataSource(String title, String description, BigdataSailRepository repo) {
        this(title, description, repo, false);
    }

    protected BlazegraphDataSource(String title, String description, BigdataSailRepository repo, boolean repoHasToBeShutDown) {
        super(title, description);
        this.repo = repo;
        this.repoHasToBeShutDown = repoHasToBeShutDown;
        this.store = repo.getDatabase();
        this.verifyStoreIsSuitable(this.store);
        this.requestProcessor = new BlazegraphBasedTPFRequestProcessor(this.store);
    }

    public static Properties check(Properties props, String title) throws DataSourceCreationException {
        String bufMode = props.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE);
        if (!bufMode.equals("MemStore") && props.containsKey(Options.FILE)) {
            String fname = props.getProperty(Options.FILE);
            File file = new File(fname);
            if (!file.exists()) {
                throw new DataSourceCreationException(title, "Blazegraph journal does not exist (" + fname + ").");
            }
            if (!file.canRead()) {
                throw new DataSourceCreationException(title, "Blazegraph journal cannot be read (" + fname + ").");
            }
        }
        return props;
    }

    public void verifyStoreIsSuitable(AbstractTripleStore store) {
        if (store.isQuads()) {
            throw new IllegalArgumentException("The given store must be for triples (not quads).");
        }
        if (store.isStatementIdentifiers()) {
            throw new IllegalArgumentException("The given store must not support RDR/SIDS.");
        }
        if (store.isJustify()) {
            throw new IllegalArgumentException("The given store must not support justication of entailments.");
        }
    }

    public void close() {
        System.out.println("SHUTTING DOWN THE REPO");
        if (this.repoHasToBeShutDown) {
            try {
                this.repo.shutDown();
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void loadData(String filename) throws DataSourceCreationException {
        BigdataSailRepositoryConnection cxn;
        if (filename == null) {
            return;
        }
        try {
            cxn = this.repo.getConnection();
            cxn.begin();
        }
        catch (RepositoryException e) {
            throw new DataSourceCreationException((Throwable)e);
        }
        try {
            String baseURL = "http://db.uwaterloo.ca/~galuc/wsdbm/";
            FileInputStream is = new FileInputStream(filename);
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(is));
            cxn.add((Reader)reader, "http://db.uwaterloo.ca/~galuc/wsdbm/", RDFFormat.forFileName((String)filename), new Resource[0]);
            cxn.commit();
        }
        catch (Exception e) {
            try {
                cxn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DataSourceCreationException((Throwable)e);
        }
        finally {
            try {
                cxn.close();
            }
            catch (Exception exception) {}
        }
    }

    public IFragmentRequestParser getRequestParser() {
        return new TPFRequestParserForBlazegraph(this.store.getLexiconRelation());
    }

    public IFragmentRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }
}

