/**

Copyright (C) SYSTAP, LLC DBA Blazegraph 2006-2016.  All rights reserved.

Contact:
     SYSTAP, LLC DBA Blazegraph
     2501 Calvert ST NW #106
     Washington, DC 20008
     licenses@blazegraph.com

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
 * Created on Mar 31, 2011
 */

package com.bigdata.bop.join;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.joinGraph.rto.JoinGraph;

/**
 * Common annotations for various join operators.
 * 
 * @author <a href="mailto:thompsonbry@users.sourceforge.net">Bryan Thompson</a>
 * @version $Id$
 */
public interface JoinAnnotations extends com.bigdata.bop.PipelineOp.Annotations {

//    /**
//     * Boolean annotation is <code>true</code> iff the solutions will be
//     * re-integrated into the query plan using an OPTIONAL join.
//     * <p>
//     * Note: Constraints on the join ARE NOT applied to the "optional" path.
//     * 
//     * Note: The code is a bit incoherent concerning where this annotation is
//     * place. For the AST, it needs to be on the node which models the join.
//     * E.g., StatementPatternNode, JoinGroupNode, etc. For a Predicate, it is on
//     * the Predicate. For a PipelineOp, it is found on the Predicate if the JOIN
//     * is against an access path and otherwise it is (I believe) found on the
//     * PipelineOp itself. It would probably be best if the annotation was put
//     * onto the physical join operator (PipelineOp) when that operator is
//     * generated by the query planner. Thus the annotation would be propagated
//     * from the AST to the physical query plan. (I believe the reason why this
//     * annotation is on the Predicate is two fold. First, we originally did not
//     * have the AST abstraction, and it still does not exist for IRules. Second,
//     * the idea was that the RTO would operate in terms of a Predicate[], and
//     * hence the notion of "optional" needed to be on the Predicate, but it now
//     * looks like it will operate in terms of the AST model instead where it is
//     * visible to the RTO.)
//     */
//    String OPTIONAL = JoinAnnotations.class.getName() + ".optional";
//
//    boolean DEFAULT_OPTIONAL = false;
    
    /**
     * The {@link JoinTypeEnum} for join (required).
     * <p>
     * Note: Not all join operators support all join types. For example,
     * {@link PipelineJoin} supports {@link JoinTypeEnum#Normal} and
     * {@link JoinTypeEnum#Optional}. The hash join operators tend to support
     * more join types, but some hash join operators only support
     * {@link JoinTypeEnum#Normal} joins because the solutions from the query
     * engine are flowing through the join rather than being at a fixed point in
     * a hash index which is then fed into the join. When the query engine
     * solutions are folowing through the join it is not possible to do any of
     * the non-required joins (Optional, Exists, NotExists).
     * 
     * @see JoinTypeEnum
     */
    String JOIN_TYPE = JoinAnnotations.class.getName() + ".joinType";

    /**
     * An optional {@link IVariable}[] identifying the variables to be retained
     * in the {@link IBindingSet}s written out by the operator. All variables
     * are retained unless this annotation is specified.
     */
    String SELECT = JoinAnnotations.class.getName() + ".select";
    
    /**
     * An {@link IConstraint}[] which places restrictions on the legal patterns
     * in the variable bindings (optional).
     * <p>
     * Note: Constraints are applied to input solutions which join. If an input
     * solution does not join and the {@link IPredicate} is
     * {@link IPredicate.Annotations#OPTIONAL} then the {@link #CONSTRAINTS} are
     * NOT tested and the original solution is output.
     */
    String CONSTRAINTS = JoinAnnotations.class.getName() + ".constraints";

    /**
     * The maximum #of solutions which will be generated by the join (default
     * {@value #DEFAULT_LIMIT}).
     * <p>
     * Note: This annotation is used by the RTO to sample evaluation plans. Not
     * all joins support this annotation and the RTO is responsible for using
     * only those joins which DO support this annotation when sampling cutoff
     * evaluation of operator path segments.
     * 
     * @see JoinGraph
     */
    String LIMIT = JoinAnnotations.class.getName() + ".limit";

    long DEFAULT_LIMIT = Long.MAX_VALUE;

}
