/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.locator.ILocatableResource;
import com.bigdata.service.IBigdataFederation;
import java.util.concurrent.Executor;

public class BOpContextBase {
    private final IBigdataFederation<?> fed;
    private final IIndexManager indexManager;
    private final Executor executor;

    public final IIndexManager getIndexManager() {
        return this.indexManager;
    }

    public final IBigdataFederation<?> getFederation() {
        return this.fed;
    }

    public final Executor getExecutorService() {
        return this.executor;
    }

    public BOpContextBase(QueryEngine queryEngine) {
        this(queryEngine.getFederation(), queryEngine.getIndexManager());
    }

    public BOpContextBase(IBigdataFederation<?> fed, IIndexManager localIndexManager) {
        this.fed = fed;
        this.indexManager = localIndexManager;
        this.executor = localIndexManager == null ? null : localIndexManager.getExecutorService();
    }

    public <E> IRelation<E> getRelation(IPredicate<E> pred) {
        String namespace = pred.getOnlyRelationName();
        long timestamp = pred.getTimestamp();
        return (IRelation)this.getResource(namespace, timestamp);
    }

    public ILocatableResource<?> getResource(String namespace, long timestamp) {
        IBigdataFederation<?> tmp = this.getFederation() == null ? this.getIndexManager() : this.getFederation();
        return tmp.getResourceLocator().locate(namespace, timestamp);
    }

    public <E> IAccessPath<E> getAccessPath(IRelation<E> relation, IPredicate<E> predicate) {
        if (relation == null) {
            throw new IllegalArgumentException();
        }
        if (predicate == null) {
            throw new IllegalArgumentException();
        }
        return relation.getAccessPath(this.indexManager, relation.getKeyOrder(predicate), predicate);
    }
}

