/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.bindingSet;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ListBindingSet
implements IBindingSet {
    private static final long serialVersionUID = 1L;
    private final List<E> current;
    private int hash;

    private final List<E> current() {
        return this.current;
    }

    public ListBindingSet() {
        this.current = new LinkedList<E>();
    }

    public ListBindingSet(IVariable[] vars, IConstant[] vals) {
        this();
        if (vars == null) {
            throw new IllegalArgumentException();
        }
        if (vals == null) {
            throw new IllegalArgumentException();
        }
        if (vars.length != vals.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < vars.length; ++i) {
            this.set(vars[i], vals[i]);
        }
    }

    protected ListBindingSet(ListBindingSet src, IVariable[] variablesToKeep) {
        this.current = this.copy(src.current, variablesToKeep);
    }

    private List<E> copy(List<E> src, IVariable[] variablesToKeep) {
        LinkedList<E> dst = new LinkedList<E>();
        for (E e : src) {
            boolean keep = true;
            if (variablesToKeep != null) {
                keep = false;
                for (IVariable x : variablesToKeep) {
                    if (x != e.var) continue;
                    keep = true;
                    break;
                }
            }
            if (!keep) continue;
            dst.add(new E(e.var, e.val));
        }
        return dst;
    }

    public ListBindingSet clone() {
        return new ListBindingSet(this, null);
    }

    public IBindingSet copy(IVariable[] variablesToKeep) {
        return new ListBindingSet(this, variablesToKeep);
    }

    public void clear(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        List<E> cur = this.current();
        for (E e : cur) {
            if (e.var != var) continue;
            cur.remove(e);
            this.hash = 0;
            return;
        }
    }

    public void clearAll() {
        this.current().clear();
        this.hash = 0;
    }

    public IConstant get(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        List<E> cur = this.current();
        for (E e : cur) {
            if (e.var != var) continue;
            return e.val;
        }
        return null;
    }

    public boolean isBound(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        List<E> cur = this.current();
        for (E e : cur) {
            if (e.var != var) continue;
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<IVariable, IConstant>> iterator() {
        return this.current().iterator();
    }

    public void set(IVariable var, IConstant val) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            throw new IllegalArgumentException();
        }
        List<E> cur = this.current();
        for (E e : cur) {
            if (e.var != var) continue;
            e.val = val;
            this.hash = 0;
            return;
        }
        cur.add(new E(var, val));
        this.hash = 0;
    }

    public boolean isEmpty() {
        return this.current().isEmpty();
    }

    public int size() {
        return this.current().size();
    }

    public Iterator<IVariable> vars() {
        return new Striterator(Collections.unmodifiableList(this.current()).iterator()).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                return ((E)obj).var;
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int i = 0;
        Iterator<E> itr = this.current().iterator();
        while (itr.hasNext()) {
            if (i > 0) {
                sb.append(", ");
            }
            E entry = itr.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (!(t instanceof IBindingSet)) {
            return false;
        }
        IBindingSet o = (IBindingSet)t;
        if (this.size() != o.size()) {
            return false;
        }
        for (E entry : this.current()) {
            IVariable<?> var = entry.getKey();
            IConstant<?> val = entry.getValue();
            IConstant o_val = o.get(var);
            if (null != o_val && val.equals((Object)o_val)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 0;
            List<E> cur = this.current();
            for (E e : cur) {
                if (e.val == null) continue;
                result ^= e.val.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    private static class E
    implements Map.Entry<IVariable<?>, IConstant<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IVariable<?> var;
        private IConstant<?> val;

        E(IVariable<?> var, IConstant<?> val) {
            this.var = var;
            this.val = val;
        }

        @Override
        public IVariable<?> getKey() {
            return this.var;
        }

        @Override
        public IConstant<?> getValue() {
            return this.val;
        }

        @Override
        public IConstant<?> setValue(IConstant<?> value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            IConstant<?> tmp = this.val;
            this.val = value;
            return tmp;
        }

        public String toString() {
            return this.var + "=" + this.val;
        }
    }
}

