/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IShardwisePipelineOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IBindingSetAccessPath;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public abstract class HashJoinOp<E>
extends PipelineOp
implements IShardwisePipelineOp<E> {
    private static final transient Logger log = Logger.getLogger(HashJoinOp.class);
    private static final long serialVersionUID = 1L;

    public HashJoinOp(HashJoinOp<E> op) {
        super(op);
    }

    public HashJoinOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public HashJoinOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        IVariable[] joinVars;
        switch (this.getEvaluationContext()) {
            case CONTROLLER: 
            case SHARDED: 
            case HASHED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + this.getEvaluationContext());
            }
        }
        this.getPredicate();
        this.getRequiredProperty("namedSetRef");
        for (IVariable var : joinVars = (IVariable[])this.getRequiredProperty(Annotations.JOIN_VARS)) {
            if (var != null) continue;
            throw new IllegalArgumentException(Annotations.JOIN_VARS);
        }
    }

    @Override
    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    protected boolean isOptional() {
        return this.getPredicate().isOptional();
    }

    @Override
    public BaseJoinStats newStats() {
        return new BaseJoinStats();
    }

    protected abstract IHashJoinUtility newState(BOpContext<IBindingSet> var1, INamedSolutionSetRef var2, JoinTypeEnum var3);

    protected abstract boolean runHashJoin(BOpContext<?> var1, IHashJoinUtility var2);

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask<E>
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final HashJoinOp<E> op;
        private final IRelation<E> relation;
        private final IPredicate<E> pred;
        private final BaseJoinStats stats;
        private final IHashJoinUtility state;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> sink2;

        public ChunkTask(BOpContext<IBindingSet> context, HashJoinOp<E> op) {
            this.context = context;
            this.stats = (BaseJoinStats)context.getStats();
            this.pred = op.getPredicate();
            this.relation = context.getRelation(this.pred);
            this.sink = context.getSink();
            this.sink2 = context.getSink2();
            this.op = op;
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            IQueryAttributes attrs = context.getQueryAttributes(namedSetRef.getQueryId());
            IHashJoinUtility state = (IHashJoinUtility)attrs.get(namedSetRef);
            if (state == null) {
                state = op.newState(context, namedSetRef, op.isOptional() ? JoinTypeEnum.Optional : JoinTypeEnum.Normal);
                attrs.put(namedSetRef, state);
            }
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            boolean didRun = false;
            try {
                this.acceptSolutions();
                if (this.op.runHashJoin(this.context, this.state)) {
                    didRun = true;
                    this.doHashJoin();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                if (didRun) {
                    this.state.release();
                }
                this.sink.close();
                if (this.sink2 != null) {
                    this.sink2.close();
                }
            }
        }

        private void acceptSolutions() {
            this.state.acceptSolutions(this.context.getSource(), this.stats);
        }

        private IBindingSetAccessPath<?> getAccessPath() {
            return (IBindingSetAccessPath)((Object)this.context.getAccessPath(this.relation, this.pred));
        }

        private void doHashJoin() {
            if (this.state.isEmpty()) {
                return;
            }
            IBindingSetAccessPath<?> accessPath = this.getAccessPath();
            if (log.isInfoEnabled()) {
                log.info((Object)("accessPath=" + accessPath));
            }
            this.stats.accessPathCount.increment();
            this.stats.accessPathRangeCount.add(accessPath.rangeCount(false));
            UnsyncLocalOutputBuffer unsyncBuffer = new UnsyncLocalOutputBuffer(this.op.getChunkCapacity(), this.sink);
            long cutoffLimit = (Long)this.pred.getProperty(IPredicate.Annotations.CUTOFF_LIMIT, Long.MAX_VALUE);
            ICloseableIterator<IBindingSet[]> itr = accessPath.solutions(this.context, cutoffLimit, this.stats);
            this.state.hashJoin(itr, null, unsyncBuffer);
            switch (this.state.getJoinType()) {
                case Normal: {
                    break;
                }
                case Optional: 
                case NotExists: {
                    UnsyncLocalOutputBuffer unsyncBuffer2 = this.sink2 == null ? unsyncBuffer : new UnsyncLocalOutputBuffer(this.op.getChunkCapacity(), this.sink2);
                    this.state.outputOptionals(unsyncBuffer2);
                    unsyncBuffer2.flush();
                    if (this.sink2 == null) break;
                    this.sink2.flush();
                    break;
                }
                case Exists: {
                    this.state.outputJoinSet(unsyncBuffer);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            unsyncBuffer.flush();
            this.sink.flush();
        }
    }

    public static interface Annotations
    extends AccessPathJoinAnnotations,
    NamedSetAnnotations,
    HashJoinAnnotations {
    }
}

