/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class DataSetJoin
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public DataSetJoin(DataSetJoin op) {
        super(op);
    }

    public DataSetJoin(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getVar();
        this.getGraphs();
    }

    public DataSetJoin(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public IVariable<?> getVar() {
        return (IVariable)this.getRequiredProperty(Annotations.VAR);
    }

    public Set<IV> getGraphs() {
        return (Set)this.getRequiredProperty(Annotations.GRAPHS);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new DataSetJoinTask(this, context));
    }

    private static class DataSetJoinTask
    implements Callable<Void> {
        private final DataSetJoin op;
        private final BOpContext<IBindingSet> context;
        private final IVariable<?> var;
        private final Set<IV> graphs;

        DataSetJoinTask(DataSetJoin op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            this.var = op.getVar();
            this.graphs = op.getGraphs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> source = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            try {
                BOpStats stats = this.context.getStats();
                UnsynchronizedArrayBuffer<IBindingSet> tmp = new UnsynchronizedArrayBuffer<IBindingSet>(sink, IBindingSet.class, this.op.getChunkCapacity());
                while (source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])source.next();
                    stats.chunksIn.increment();
                    stats.unitsIn.add(chunk.length);
                    this.handleChunk(chunk, tmp);
                }
                tmp.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                source.close();
            }
        }

        private void handleChunk(IBindingSet[] chunk, UnsynchronizedArrayBuffer<IBindingSet> tmp) {
            for (IBindingSet bset : chunk) {
                IConstant val = bset.get(this.var);
                if (val == null) {
                    for (IV c : this.graphs) {
                        bset = bset.clone();
                        bset.set(this.var, new Constant<IV>(c));
                        tmp.add(bset);
                    }
                    continue;
                }
                if (!this.graphs.contains(val.get())) continue;
                tmp.add(bset);
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String VAR = DataSetJoin.class.getName() + ".var";
        public static final String GRAPHS = DataSetJoin.class.getName() + ".graphs";
    }
}

