/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.IAbstractNode;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.Leaf;
import com.bigdata.btree.LeafTupleIterator;
import com.bigdata.btree.Node;
import com.bigdata.btree.PO;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.btree.data.IKeysData;
import com.bigdata.btree.filter.EmptyTupleIterator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractNode<T extends AbstractNode>
extends PO
implements IAbstractNode,
IAbstractNodeData,
IKeysData {
    protected static final Logger log = Logger.getLogger(AbstractNode.class);
    protected static final boolean DEBUG = log.isDebugEnabled();
    protected final transient AbstractBTree btree;
    protected transient Reference<Node> parent = null;
    protected final transient Reference<? extends AbstractNode<T>> self;
    protected transient int referenceCount = 0;

    protected abstract int minKeys();

    protected abstract int maxKeys();

    abstract IAbstractNodeData getDelegate();

    @Override
    public void delete() {
        if (this.deleted) {
            throw new IllegalStateException();
        }
        this.parent = null;
        if (this.identity != 0L) {
            // empty if block
        }
        this.deleted = true;
    }

    public final Node getParent() {
        Node p = null;
        if (this.parent != null) {
            p = this.parent.get();
        }
        assert (this == this.btree.root && p == null || p != null);
        return p;
    }

    private AbstractNode() {
        throw new UnsupportedOperationException();
    }

    protected AbstractNode(AbstractBTree btree, boolean dirty) {
        assert (btree != null);
        this.btree = btree;
        this.self = btree.newRef(this);
        if (!dirty) {
            this.setDirty(false);
        }
        btree.touch(this);
    }

    protected AbstractNode(AbstractNode<T> src) {
        this(src.btree, true);
        assert (this.isDirty());
        assert (!this.isPersistent());
        assert (!src.isDirty());
        assert (src.isReadOnly());
        assert (src == this.btree.root || src.parent != null && src.parent.get() != null);
        this.parent = src.parent;
    }

    protected AbstractNode<?> copyOnWrite() {
        assert (this.isLeaf());
        return this.copyOnWrite(0L);
    }

    protected AbstractNode<T> copyOnWrite(long triggeredByChildId) {
        AbstractNode newNode;
        if (!this.isReadOnly()) {
            this.btree.touch(this);
            return this;
        }
        if (DEBUG) {
            log.debug((Object)("this=" + this + ", trigger=" + triggeredByChildId));
        }
        BTree btree = (BTree)this.btree;
        long oldId = this.identity;
        Node parent = this.getParent();
        if (this instanceof Node) {
            newNode = new Node((Node)this, triggeredByChildId);
            ++btree.getBtreeCounters().nodesCopyOnWrite;
        } else {
            newNode = new Leaf((Leaf)this);
            ++btree.getBtreeCounters().leavesCopyOnWrite;
        }
        this.delete();
        if (btree.root == this) {
            assert (parent == null);
            if (DEBUG) {
                log.debug((Object)"Copy-on-write : replaced root node on btree.");
            }
            boolean wasDirty = btree.root.dirty;
            assert (newNode != null);
            btree.root = newNode;
            if (!wasDirty) {
                btree.fireDirtyEvent();
            }
        } else {
            assert (parent != null);
            if (!parent.isDirty()) {
                parent = (Node)parent.copyOnWrite(oldId);
            }
            parent.replaceChildRef(oldId, newNode);
        }
        return newNode;
    }

    @Override
    public final Iterator<AbstractNode> postOrderNodeIterator() {
        return this.postOrderNodeIterator(false, false);
    }

    public final Iterator<AbstractNode> postOrderNodeIterator(boolean dirtyNodesOnly) {
        return this.postOrderNodeIterator(dirtyNodesOnly, false);
    }

    public abstract Iterator<AbstractNode> postOrderNodeIterator(boolean var1, boolean var2);

    @Override
    public ITupleIterator entryIterator() {
        return this.rangeIterator(null, null, 3);
    }

    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int flags) {
        return new PostOrderEntryIterator(this.btree, this.postOrderIterator(fromKey, toKey), fromKey, toKey, flags);
    }

    public abstract Iterator<AbstractNode> postOrderIterator(byte[] var1, byte[] var2);

    protected final void assertInvariants() {
        AbstractNode<?> root = this.btree.root;
        assert (root == this || this.parent != null && this.parent.get() != null);
        if (root != this && (this.btree instanceof IndexSegment ? !$assertionsDisabled && this.getKeyCount() < 1 : !$assertionsDisabled && this.getKeyCount() < this.minKeys())) {
            throw new AssertionError();
        }
        assert (this.getKeyCount() <= this.maxKeys());
    }

    protected final void assertKeysMonotonic() {
        if (this.getKeys() instanceof MutableKeyBuffer) {
            ((MutableKeyBuffer)this.getKeys()).assertKeysMonotonic();
        }
    }

    protected static final String keyAsString(byte[] key) {
        return BytesUtil.toString((byte[])key);
    }

    protected final void copyKey(int dstpos, IRaba srckeys, int srcpos) {
        assert (this.dirty);
        ((MutableKeyBuffer)this.getKeys()).keys[dstpos] = srckeys.get(srcpos);
    }

    @Override
    public abstract boolean isLeaf();

    public final int getBranchingFactor() {
        return this.btree.branchingFactor;
    }

    protected abstract IAbstractNode split();

    protected void join() {
        long triggeredByChildId = 0L;
        assert (this.getKeyCount() < this.minKeys());
        assert (this.getKeyCount() == this.minKeys() - 1);
        assert (this.isDirty());
        assert (!this.isPersistent());
        assert (((BTree)this.btree).root != this);
        Node parent = this.getParent();
        if (DEBUG) {
            log.debug((Object)("this=" + this));
        }
        if (this.isLeaf()) {
            ++this.btree.getBtreeCounters().leavesJoined;
        } else {
            ++this.btree.getBtreeCounters().nodesJoined;
        }
        AbstractNode rightSibling = parent.getRightSibling(this, false);
        AbstractNode leftSibling = parent.getLeftSibling(this, false);
        if (rightSibling != null && rightSibling.getKeyCount() > rightSibling.minKeys()) {
            this.redistributeKeys(rightSibling.copyOnWrite(0L), true);
            return;
        }
        if (leftSibling != null && leftSibling.getKeyCount() > leftSibling.minKeys()) {
            this.redistributeKeys(leftSibling.copyOnWrite(0L), false);
            return;
        }
        if (rightSibling == null && (rightSibling = parent.getRightSibling(this, true)) != null && rightSibling.getKeyCount() > rightSibling.minKeys()) {
            this.redistributeKeys(rightSibling.copyOnWrite(0L), true);
            return;
        }
        if (leftSibling == null && (leftSibling = parent.getLeftSibling(this, true)) != null && leftSibling.getKeyCount() > leftSibling.minKeys()) {
            this.redistributeKeys(leftSibling.copyOnWrite(0L), false);
            return;
        }
        if (rightSibling != null) {
            this.merge(rightSibling, true);
            return;
        }
        if (leftSibling != null) {
            this.merge(leftSibling, false);
            return;
        }
        throw new AssertionError();
    }

    protected boolean isLeftMostNode() {
        Node p = this.getParent();
        if (p == null) {
            return true;
        }
        int i = p.getIndexOf(this);
        if (i == 0) {
            return p.isLeftMostNode();
        }
        return false;
    }

    protected boolean isRightMostNode() {
        Node p = this.getParent();
        if (p == null) {
            return true;
        }
        int i = p.getIndexOf(this);
        if (i == p.getKeyCount()) {
            return p.isRightMostNode();
        }
        return false;
    }

    protected abstract void redistributeKeys(AbstractNode var1, boolean var2);

    protected abstract void merge(AbstractNode var1, boolean var2);

    public abstract Tuple insert(byte[] var1, byte[] var2, boolean var3, boolean var4, long var5, Tuple var7);

    public abstract Tuple remove(byte[] var1, Tuple var2);

    public abstract Tuple lookup(byte[] var1, Tuple var2);

    public abstract long indexOf(byte[] var1);

    public abstract byte[] keyAt(long var1);

    public abstract void valueAt(long var1, Tuple var3);

    public boolean dump(PrintStream out) {
        return this.dump(BTree.dumpLog.getEffectiveLevel(), out);
    }

    public boolean dump(Level level, PrintStream out) {
        return this.dump(level, out, -1, false);
    }

    public abstract boolean dump(Level var1, PrintStream var2, int var3, boolean var4);

    private static class PostOrderEntryIterator
    implements ITupleIterator {
        private final Tuple tuple;
        private final IStriterator src;

        @Override
        public boolean hasNext() {
            return this.src.hasNext();
        }

        @Override
        public ITuple next() {
            return (ITuple)this.src.next();
        }

        @Override
        public void remove() {
            this.src.remove();
        }

        public PostOrderEntryIterator(AbstractBTree btree, Iterator postOrderNodeIterator, final byte[] fromKey, final byte[] toKey, int flags) {
            assert (postOrderNodeIterator != null);
            this.tuple = new Tuple(btree, flags);
            this.src = new Striterator(postOrderNodeIterator);
            this.src.addFilter((IFilter)new Expander(){
                private static final long serialVersionUID = 1L;

                protected Iterator expand(Object childObj) {
                    AbstractNode child = (AbstractNode)childObj;
                    if (child instanceof Leaf) {
                        Leaf leaf = (Leaf)child;
                        if (leaf.getKeys().isEmpty()) {
                            return EmptyTupleIterator.INSTANCE;
                        }
                        return new LeafTupleIterator(leaf, PostOrderEntryIterator.this.tuple, fromKey, toKey);
                    }
                    return EmptyTupleIterator.INSTANCE;
                }
            });
        }
    }
}

