/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IBloomFilter;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.io.LongPacker;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rawstore.IRawStore;
import it.unimi.dsi.util.BloomFilter2;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class BloomFilter
implements IBloomFilter,
Externalizable {
    private static final transient Logger log = Logger.getLogger(BloomFilter.class);
    private static final long serialVersionUID = -4011582802868293737L;
    private BloomFilter2 filter;
    private static final transient double LN2 = Math.log(2.0);
    private int n;
    private double p;
    private int maxN;
    private transient long addr;
    private transient boolean dirty = false;
    private transient boolean enabled = true;
    private static final transient int VERSION0 = 0;
    public transient BloomFilterCounters counters = new BloomFilterCounters();

    public final int getN() {
        return this.n;
    }

    public final double getP() {
        return this.p;
    }

    public double getErrorRate() {
        return Math.pow(2.0, -this.filter.d());
    }

    public final int getMaxN() {
        return this.maxN;
    }

    public BloomFilter() {
    }

    public BloomFilter(int n, double p) {
        this(n, p, n * 2);
    }

    public BloomFilter(int n, double p, int maxN) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        if (p <= 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (maxN < n) {
            throw new IllegalArgumentException();
        }
        int d = BloomFilter.getHashFunctionCount(p);
        this.filter = new BloomFilter2(n, d);
        if (log.isDebugEnabled()) {
            log.debug((Object)("n=" + n + ", p=" + p + ", d=" + d + ", m=" + this.filter.m()));
        }
        this.n = n;
        this.p = p;
        this.maxN = maxN;
    }

    public final int getHashFunctionCount() {
        return this.filter.d();
    }

    public final long getBitLength() {
        return this.filter.m();
    }

    public static int getHashFunctionCount(double errorRate) {
        if (errorRate <= 0.0 || errorRate > 1.0) {
            throw new IllegalArgumentException();
        }
        double p = errorRate;
        double d2 = -(Math.log(p) / LN2);
        int d = (int)Math.ceil(d2);
        return d;
    }

    public static long getBitLength(int hashFunctionCount, int nentries) {
        long bitLength = (long)Math.ceil((double)nentries * ((double)hashFunctionCount / LN2));
        return bitLength;
    }

    public static int getEntryCountForErrorRate(int k, long m, double p) {
        double n = (double)(-m) * Math.log(1.0 - Math.pow(p, 1.0 / (double)k)) / (double)k;
        if (log.isDebugEnabled()) {
            log.debug((Object)("p=" + p + ", m=" + m + ", k=" + k + ", n=" + n));
        }
        return (int)n;
    }

    @Override
    public boolean add(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.enabled) {
            throw new IllegalStateException();
        }
        if (this.filter.add(key)) {
            this.dirty = true;
            ++this.counters.nbloomAdd;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.enabled) {
            throw new IllegalStateException();
        }
        ++this.counters.nbloomTest;
        if (!this.filter.contains(key)) {
            ++this.counters.nbloomRejects;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BloomFilter");
        sb.append("{ minSize=" + this.filter.size());
        sb.append(", n=" + this.n);
        sb.append(", p=" + this.p);
        sb.append(", maxN=" + this.maxN);
        sb.append(", bitLength=" + this.filter.m());
        sb.append(", hashFunctionCount=" + this.filter.d());
        sb.append(", errorRate=" + this.getErrorRate());
        if (this.dirty) {
            sb.append(", dirty");
        }
        if (!this.enabled) {
            sb.append(", disabled");
        }
        if (this.addr != 0L) {
            sb.append(", addr=" + this.addr);
        }
        sb.append("}");
        return sb.toString();
    }

    public final long getAddr() {
        return this.addr;
    }

    public static BloomFilter read(IRawStore store, long addr) {
        BloomFilter filter = (BloomFilter)SerializerUtil.deserialize(store.read(addr));
        filter.addr = addr;
        if (log.isInfoEnabled()) {
            log.info((Object)("Read bloom filter: bytesOnDisk=" + store.getByteCount(addr) + ": " + filter));
        }
        return filter;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public long write(IRawStore store) {
        if (!this.dirty) {
            throw new IllegalStateException();
        }
        if (!this.enabled) {
            throw new IllegalStateException();
        }
        this.addr = store.write(ByteBuffer.wrap(SerializerUtil.serialize(this)));
        this.dirty = false;
        if (log.isInfoEnabled()) {
            log.info((Object)("Wrote bloom filter: bytesOnDisk=" + store.getByteCount(this.addr) + ": " + this.filter));
        }
        return this.addr;
    }

    public final long disable() {
        long ret = this.addr;
        if (this.enabled) {
            this.enabled = false;
            this.filter = null;
            this.addr = 0L;
            if (log.isInfoEnabled()) {
                log.info((Object)"disabled.");
            }
        }
        return ret;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = (int)LongPacker.unpackLong(in);
        if (version != 0) {
            throw new IOException("Unknown version=" + version);
        }
        this.n = (int)LongPacker.unpackLong(in);
        this.maxN = (int)LongPacker.unpackLong(in);
        this.p = in.readDouble();
        this.filter = (BloomFilter2)in.readObject();
        this.dirty = false;
        this.addr = 0L;
        this.enabled = true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        LongPacker.packLong(out, 0L);
        LongPacker.packLong(out, (long)this.n);
        LongPacker.packLong(out, (long)this.maxN);
        out.writeDouble(this.p);
        out.writeObject(this.filter);
    }

    @Override
    public void falsePos() {
        ++this.counters.nbloomFalsePos;
    }

    public static class BloomFilterCounters {
        public int nbloomAdd = 0;
        public int nbloomTest = 0;
        public int nbloomRejects = 0;
        public int nbloomFalsePos = 0;
        private CounterSet counterSet;

        public void add(BloomFilterCounters o) {
            this.nbloomAdd += o.nbloomAdd;
            this.nbloomTest += o.nbloomTest;
            this.nbloomRejects += o.nbloomRejects;
            this.nbloomFalsePos += o.nbloomFalsePos;
        }

        public double getBloomAcceptRate() {
            return 1.0 - this.getBloomRejectionRate();
        }

        public double getBloomRejectionRate() {
            if (this.nbloomTest == 0) {
                return 0.0;
            }
            return (double)this.nbloomRejects / (double)this.nbloomTest;
        }

        public double getBloomErrorRate() {
            if (this.nbloomTest == 0) {
                return 0.0;
            }
            return (double)this.nbloomFalsePos / (double)this.nbloomTest;
        }

        public synchronized ICounterSet getCounters() {
            if (this.counterSet == null) {
                this.counterSet = new CounterSet();
                this.counterSet.addCounter("#add", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.nbloomAdd);
                    }
                });
                this.counterSet.addCounter("#test", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.nbloomTest);
                    }
                });
                this.counterSet.addCounter("#reject", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.nbloomRejects);
                    }
                });
                this.counterSet.addCounter("#falsePos", new Instrument<Integer>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.nbloomFalsePos);
                    }
                });
                this.counterSet.addCounter("rejectRate", new Instrument<Double>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.getBloomRejectionRate());
                    }
                });
                this.counterSet.addCounter("errorRate", new Instrument<Double>(){

                    @Override
                    protected void sample() {
                        this.setValue(BloomFilterCounters.this.getBloomErrorRate());
                    }
                });
            }
            return this.counterSet;
        }

        public String toString() {
            return this.getCounters().asXML(null);
        }

        public String getBloomFilterPerformance() {
            return "bloom filter: nadd=" + this.nbloomAdd + ", ntest=" + this.nbloomTest + ", nreject=" + this.nbloomRejects + ", nfalsePos=" + this.nbloomFalsePos + ", rejectRate=" + this.getBloomRejectionRate() + ", errorRate=" + this.getBloomErrorRate();
        }
    }
}

