/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba.codec;

import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;

public class EmptyRabaValueCoder
implements IRabaCoder,
Externalizable {
    private static final long serialVersionUID = -8011456562258609162L;
    public static final transient EmptyRabaValueCoder INSTANCE = new EmptyRabaValueCoder();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public final boolean isKeyCoder() {
        return false;
    }

    @Override
    public final boolean isValueCoder() {
        return true;
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        if (raba == null) {
            throw new IllegalArgumentException();
        }
        if (raba.isKeys()) {
            throw new UnsupportedOperationException();
        }
        int O_origin = buf.pos();
        int size = raba.size();
        buf.putInt(size);
        return new EmptyCodedRaba(buf.slice(O_origin, buf.pos() - O_origin), size);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        if (raba == null) {
            throw new IllegalArgumentException();
        }
        if (raba.isKeys()) {
            throw new UnsupportedOperationException();
        }
        int O_origin = buf.pos();
        buf.putInt(raba.size());
        return buf.slice(O_origin, buf.pos() - O_origin);
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new EmptyCodedRaba(data);
    }

    private static class EmptyCodedRaba
    implements ICodedRaba {
        private final AbstractFixedByteArrayBuffer data;
        private final int size;

        public EmptyCodedRaba(AbstractFixedByteArrayBuffer data) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            this.size = data.getInt(0);
        }

        public EmptyCodedRaba(AbstractFixedByteArrayBuffer data, int size) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            this.size = size;
        }

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean isKeys() {
            return false;
        }

        @Override
        public final int capacity() {
            return this.size;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        @Override
        public final boolean isNull(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }

        @Override
        public final int length(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            throw new NullPointerException();
        }

        @Override
        public final byte[] get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return null;
        }

        @Override
        public final int copy(int index, OutputStream os) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            throw new NullPointerException();
        }

        @Override
        public final Iterator<byte[]> iterator() {
            return new Iterator<byte[]>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < EmptyCodedRaba.this.size;
                }

                @Override
                public byte[] next() {
                    ++this.i;
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final int search(byte[] searchKey) {
            if (this.isKeys()) {
                return -1;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final int add(byte[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int add(byte[] value, int off, int len) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int add(DataInput in, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void set(int index, byte[] a) {
            throw new UnsupportedOperationException();
        }

        public final String toString() {
            return AbstractRaba.toString(this);
        }
    }
}

