/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.DeadlockException;
import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.concurrent.TxDag;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.AbstractTask;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.concurrent.MovingAverageTask;
import com.bigdata.util.concurrent.QueueSizeMovingAverageTask;
import com.bigdata.util.concurrent.WriteTaskCounters;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class NonBlockingLockManagerWithNewDesign<R extends Comparable<R>>
implements ICounterSetAccess {
    protected static final Logger log = Logger.getLogger(NonBlockingLockManagerWithNewDesign.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final ConcurrentWeakValueCacheWithTimeout<R, ResourceQueue<R, LockFutureTask<R, ? extends Object>>> resourceQueues = new ConcurrentWeakValueCacheWithTimeout(1000, TimeUnit.SECONDS.toNanos(60L));
    private final boolean predeclareLocks;
    private final boolean sortLockRequests;
    private final int maxLockTries;
    private final TxDag waitsFor;
    private final ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(this.getClass().getName()));
    public final StatisticsTask statisticsTask = new StatisticsTask();
    private volatile ServiceRunState serviceRunState = ServiceRunState.Starting;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition stateChanged = this.lock.newCondition();
    private final BlockingQueue<LockFutureTask<R, ? extends Object>> retryQueue = new LinkedBlockingQueue<LockFutureTask<R, ? extends Object>>();
    final Counters counters = new Counters();

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("nrejected", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.counters.nrejected);
            }
        });
        root.addCounter("ncancel", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.counters.ncancel);
            }
        });
        root.addCounter("nerror", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.counters.nerror);
            }
        });
        root.addCounter("averageRetryCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nretryAverageTask.getMovingAverage());
            }
        });
        root.addCounter("averageWaitingCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nwaitingAverageTask.getMovingAverage());
            }
        });
        root.addCounter("averageReadyCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nreadyAverageTask.getMovingAverage());
            }
        });
        root.addCounter("averageQueueBusyCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nqueueBusyAverageTask.getMovingAverage());
            }
        });
        root.addCounter("averageRunningCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nrunningAverageTask.getMovingAverage());
            }
        });
        root.addCounter("averageRunningWithLocksHeldCount", new Instrument<Double>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.statisticsTask.nrunningWithLocksHeldAverageTask.getMovingAverage());
            }
        });
        root.addCounter("maxRunning", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.counters.maxRunning);
            }
        });
        root.addCounter("nresourceQueues", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.resourceQueues.size());
            }
        });
        root.addCounter("runState", new Instrument<String>(){

            @Override
            public void sample() {
                this.setValue(NonBlockingLockManagerWithNewDesign.this.serviceRunState.toString());
            }
        });
        CounterSet tmp = root.makePath("queues");
        Iterator itr = this.resourceQueues.entryIterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            WeakReference queueRef = (WeakReference)entry.getValue();
            ResourceQueue queue = (ResourceQueue)queueRef.get();
            if (queue == null) continue;
            tmp.addCounter(queue.resource.toString(), new WeakRefResourceQueueInstrument(this, queue.resource));
        }
        return root;
    }

    public NonBlockingLockManagerWithNewDesign(int maxConcurrency, int maxLockTries, boolean predeclareLocks) {
        this(maxConcurrency, maxLockTries, predeclareLocks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NonBlockingLockManagerWithNewDesign(int maxConcurrency, int maxLockTries, boolean predeclareLocks, boolean sortLockRequests) {
        if (maxConcurrency < 2 && !predeclareLocks) {
            throw new IllegalArgumentException("maxConcurrency: must be 2+ unless you are predeclaring locks, not " + maxConcurrency);
        }
        if (maxLockTries < 1) {
            throw new IllegalArgumentException("maxTries: must be GTE 1, not " + maxLockTries);
        }
        if (predeclareLocks && !sortLockRequests) {
            throw new IllegalArgumentException("Sorting of lock requests MUST be enabled when locks are being predeclared.");
        }
        this.maxLockTries = maxLockTries;
        this.predeclareLocks = predeclareLocks;
        this.sortLockRequests = sortLockRequests;
        this.waitsFor = predeclareLocks ? null : new TxDag(maxConcurrency);
        this.service.submit(new AcceptTask(this));
        this.lock.lock();
        try {
            this.setServiceRunState(ServiceRunState.Running);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void ready(Runnable var1);

    public boolean isOpen() {
        return this.serviceRunState == ServiceRunState.Running;
    }

    public boolean isShutdown() {
        switch (this.serviceRunState) {
            case Shutdown: 
            case ShutdownNow: 
            case Halted: {
                return true;
            }
        }
        return false;
    }

    public boolean isTerminated() {
        return this.serviceRunState == ServiceRunState.Halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.serviceRunState.val < ServiceRunState.Shutdown.val) {
                this.setServiceRunState(ServiceRunState.Shutdown);
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Waiting for service shutdown.");
            }
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            if (log.isInfoEnabled()) {
                log.info((Object)"Service is shutdown.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        this.lock.lock();
        try {
            if (this.serviceRunState.val < ServiceRunState.ShutdownNow.val) {
                this.setServiceRunState(ServiceRunState.ShutdownNow);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void setServiceRunState(ServiceRunState newval) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!this.serviceRunState.isTransitionLegal(newval)) {
            throw new IllegalStateException("runState=" + (Object)((Object)this.serviceRunState) + ", but newValue=" + (Object)((Object)newval));
        }
        if (this.serviceRunState != newval) {
            if (INFO) {
                log.info((Object)("Set runState=" + (Object)((Object)newval)));
            }
            this.serviceRunState = newval;
            this.stateChanged.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureTask<T> submit(R[] resource, Callable<T> task) {
        if (this.serviceRunState != ServiceRunState.Running) {
            throw new RejectedExecutionException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        for (R r : resource) {
            if (r != null) continue;
            throw new IllegalArgumentException();
        }
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (this.maxLockTries <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] a = (Comparable[])resource.clone();
        if (this.sortLockRequests) {
            Arrays.sort(a);
        }
        this.lock.lock();
        try {
            if (!this.serviceRunState.tasksAccepted()) {
                ++this.counters.nrejected;
                throw new RejectedExecutionException();
            }
            LockFutureTask lockFutureTask = new LockFutureTask(this, (Comparable[])a, task).acceptTask();
            return lockFutureTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureTask<T> submit(R[] resource, Runnable task, T val) {
        if (this.serviceRunState != ServiceRunState.Running) {
            throw new RejectedExecutionException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        for (R r : resource) {
            if (r != null) continue;
            throw new IllegalArgumentException();
        }
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (this.maxLockTries <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] a = (Comparable[])resource.clone();
        if (this.sortLockRequests) {
            Arrays.sort(a);
        }
        this.lock.lock();
        try {
            if (!this.serviceRunState.tasksAccepted()) {
                ++this.counters.nrejected;
                throw new RejectedExecutionException();
            }
            LockFutureTask lockFutureTask = new LockFutureTask(this, (Comparable[])a, task, val).acceptTask();
            return lockFutureTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseLocksForTask(R[] resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (resource.length == 0) {
            return;
        }
        this.lock.lock();
        try {
            LockFutureTask task = (LockFutureTask)this.getTaskWithLocks((Comparable[])resource);
            if (task == null) {
                throw new IllegalStateException("Task does not hold all required locks");
            }
            task.setTaskRunState(TaskRunState.RunningReleasedLocks);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getTaskWithLocks(R[] resource) {
        this.lock.lock();
        try {
            LockFutureTask task = null;
            for (R r : resource) {
                ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(r);
                if (resourceQueue == null) {
                    if (DEBUG) {
                        log.debug((Object)("No task holds this lock: " + r));
                    }
                    Runnable runnable = null;
                    return runnable;
                }
                if (task == null) {
                    task = (LockFutureTask)resourceQueue.queue.peek();
                    if (task != null) continue;
                    if (DEBUG) {
                        log.debug((Object)("No task holds this lock: " + r));
                    }
                    Runnable runnable = null;
                    return runnable;
                }
                if (task == resourceQueue.queue.peek()) continue;
                if (DEBUG) {
                    log.debug((Object)("Task holding the other locks does not hold this lock: " + r));
                }
                Runnable runnable = null;
                return runnable;
            }
            if (task == null) {
                throw new AssertionError();
            }
            if (task.taskRunState != TaskRunState.RunningWithLocks) {
                throw new IllegalStateException("taskRunState=" + (Object)((Object)task.taskRunState));
            }
            LockFutureTask lockFutureTask = task;
            return lockFutureTask;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ResourceQueue<R, LockFutureTask<R, ? extends Object>> declareResource(R resource) {
        ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(resource);
        if (resourceQueue != null) {
            return resourceQueue;
        }
        resourceQueue = new ResourceQueue(this, resource);
        ResourceQueue oldval = (ResourceQueue)this.resourceQueues.putIfAbsent(resource, resourceQueue);
        if (oldval != null) {
            return oldval;
        }
        return resourceQueue;
    }

    private <T> boolean postLockRequests(LockFutureTask<R, T> task) throws DeadlockException {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        switch (this.serviceRunState) {
            case ShutdownNow: 
            case Halted: {
                throw new IllegalStateException("runState=" + (Object)((Object)this.serviceRunState));
            }
        }
        if (((LockFutureTask)task).resource.length == 0) {
            return true;
        }
        if (this.predeclareLocks && !((LockFutureTask)task).lockedResources.isEmpty()) {
            throw new IllegalStateException("Operation already has lock(s): " + task);
        }
        if (DEBUG) {
            log.debug((Object)("Acquiring lock(s): " + Arrays.toString(((LockFutureTask)task).resource)));
        }
        if (this.waitsFor != null) {
            ResourceQueue<Comparable, LockFutureTask<Comparable, Object>> resourceQueue;
            LinkedHashSet predecessors = new LinkedHashSet();
            for (Comparable r : ((LockFutureTask)task).resource) {
                resourceQueue = this.declareResource(r);
                if (((ResourceQueue)resourceQueue).queue.isEmpty()) continue;
                predecessors.addAll(((ResourceQueue)resourceQueue).queue);
            }
            if (!predecessors.isEmpty()) {
                this.waitsFor.addEdges(task, predecessors.toArray());
            }
            for (Comparable r : ((LockFutureTask)task).resource) {
                resourceQueue = this.declareResource(r);
                ((ResourceQueue)resourceQueue).queue.add(task);
                ((LockFutureTask)task).lockedResources.add(resourceQueue);
            }
            return predecessors.isEmpty();
        }
        int waitingLockCount = 0;
        for (Comparable r : ((LockFutureTask)task).resource) {
            ResourceQueue<Comparable, LockFutureTask<Comparable, Object>> resourceQueue = this.declareResource(r);
            ((ResourceQueue)resourceQueue).queue.add(task);
            if (((ResourceQueue)resourceQueue).queue.peek() != task) {
                ++waitingLockCount;
            }
            ((LockFutureTask)task).lockedResources.add(resourceQueue);
        }
        return waitingLockCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void releaseLocksForTask(LockFutureTask<R, T> t, boolean waiting) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (DEBUG) {
            log.debug((Object)("Releasing locks: " + t));
        }
        LinkedList<ResourceQueue> resourceQueues = new LinkedList<ResourceQueue>();
        try {
            Iterator itr = ((LockFutureTask)t).lockedResources.iterator();
            while (itr.hasNext()) {
                ResourceQueue resourceQueue = (ResourceQueue)itr.next();
                if (resourceQueue.queue.peek() == t) {
                    resourceQueues.add(resourceQueue);
                }
                if (!resourceQueue.queue.remove(t)) {
                    log.error((Object)("Lock request not found: resource=" + resourceQueue.getResource() + ", task=" + t));
                }
                itr.remove();
            }
        }
        catch (Throwable t2) {
            log.error((Object)this, t2);
        }
        if (this.waitsFor != null) {
            TxDag t2 = this.waitsFor;
            synchronized (t2) {
                try {
                    this.waitsFor.removeEdges(t, waiting);
                    if (this.waitsFor.releaseVertex(t)) {
                        log.error((Object)("No vertex? " + t));
                    }
                }
                catch (Throwable t22) {
                    log.error((Object)this, t22);
                }
            }
        }
        for (ResourceQueue resourceQueue : resourceQueues) {
            LockFutureTask task = (LockFutureTask)resourceQueue.queue.peek();
            if (task == null || task.taskRunState != TaskRunState.LocksRequested || !this.holdsAllLocks(task)) continue;
            if (INFO) {
                log.info((Object)("Task is ready to run: " + task));
            }
            task.setTaskRunState(TaskRunState.LocksReady);
            --this.counters.nwaiting;
            ++this.counters.nready;
            try {
                this.ready(task);
            }
            catch (Throwable t2) {
                task.setException(t2);
            }
        }
    }

    public boolean isLockHeldByTask(R lock, Runnable task) {
        ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get(lock);
        return resourceQueue.queue.peek() == task;
    }

    private boolean holdsAllLocks(LockFutureTask<R, ? extends Object> task) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        for (Comparable r : ((LockFutureTask)task).resource) {
            ResourceQueue resourceQueue = (ResourceQueue)this.resourceQueues.get((Object)r);
            assert (resourceQueue != null) : "resource=" + r;
            if (resourceQueue.isGranted(task)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "{ #rejected=" + this.counters.nrejected + ", #error=" + this.counters.nerror + ", #cancel=" + this.counters.ncancel + ", averageDeadlock=" + (double)((int)(10.0 * this.statisticsTask.nretryAverageTask.getMovingAverage())) / 10.0 + ", averageWaiting=" + (double)((int)(10.0 * this.statisticsTask.nwaitingAverageTask.getMovingAverage())) / 10.0 + ", averageReady=" + (double)((int)(10.0 * this.statisticsTask.nreadyAverageTask.getMovingAverage())) / 10.0 + ", averageRunning=" + (double)((int)(10.0 * this.statisticsTask.nrunningAverageTask.getMovingAverage())) / 10.0 + ", averageRunningWithLocksHeld=" + (double)((int)(10.0 * this.statisticsTask.nrunningWithLocksHeldAverageTask.getMovingAverage())) / 10.0 + ", #maxrunning=" + this.counters.maxRunning + "}";
    }

    protected class StatisticsTask
    implements Runnable {
        final MovingAverageTask nretryAverageTask = new MovingAverageTask("nretry", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return NonBlockingLockManagerWithNewDesign.this.counters.nretry;
            }
        });
        final MovingAverageTask nwaitingAverageTask = new MovingAverageTask("nwaiting", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return NonBlockingLockManagerWithNewDesign.this.counters.nwaiting;
            }
        });
        final MovingAverageTask nreadyAverageTask = new MovingAverageTask("nready", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return NonBlockingLockManagerWithNewDesign.this.counters.nready;
            }
        });
        final MovingAverageTask nrunningAverageTask = new MovingAverageTask("nrunning", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return NonBlockingLockManagerWithNewDesign.this.counters.nrunning;
            }
        });
        final MovingAverageTask nrunningWithLocksHeldAverageTask = new MovingAverageTask("nrunningWithLocksHeld", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return NonBlockingLockManagerWithNewDesign.this.counters.nrunningWithLocksHeld;
            }
        });
        private final AtomicInteger queueCountWithNonZeroTasks = new AtomicInteger();
        final MovingAverageTask nqueueBusyAverageTask = new MovingAverageTask("nbusy", (Callable<? extends Number>)new Callable<Integer>(){

            @Override
            public Integer call() {
                return StatisticsTask.this.queueCountWithNonZeroTasks.get();
            }
        });

        private StatisticsTask() {
        }

        @Override
        public void run() {
            this.nretryAverageTask.run();
            this.nwaitingAverageTask.run();
            this.nreadyAverageTask.run();
            this.nrunningAverageTask.run();
            this.nrunningWithLocksHeldAverageTask.run();
            int nbusy = 0;
            Iterator itr = NonBlockingLockManagerWithNewDesign.this.resourceQueues.entryIterator();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                WeakReference queueRef = (WeakReference)entry.getValue();
                ResourceQueue queue = (ResourceQueue)queueRef.get();
                if (queue == null) continue;
                queue.statisticsTask.run();
                int size = queue.queue.size();
                if (size != 1) continue;
                ++nbusy;
            }
            this.queueCountWithNonZeroTasks.set(nbusy);
            this.nqueueBusyAverageTask.run();
        }
    }

    protected static class ResourceQueue<R extends Comparable<R>, T extends LockFutureTask<R, ? extends Object>> {
        private final NonBlockingLockManagerWithNewDesign<R> lockService;
        private final R resource;
        private final BlockingQueue<T> queue;
        final QueueSizeMovingAverageTask statisticsTask;

        public R getResource() {
            return this.resource;
        }

        public boolean isLocked() {
            return !this.queue.isEmpty();
        }

        public int getQueueSize() {
            return Math.max(0, this.queue.size() - 1);
        }

        public boolean isGranted(T tx) {
            if (tx == null) {
                throw new IllegalArgumentException();
            }
            return this.queue.peek() == tx;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{resource=" + this.resource + ", queue=" + this.queue.toString() + "}";
        }

        public ResourceQueue(NonBlockingLockManagerWithNewDesign<R> lockService, R resource) {
            if (lockService == null) {
                throw new IllegalArgumentException();
            }
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            this.lockService = lockService;
            this.resource = resource;
            this.queue = new LinkedBlockingQueue<T>();
            this.statisticsTask = new QueueSizeMovingAverageTask(resource.toString(), this.queue);
        }
    }

    private static class AcceptTask<R extends Comparable<R>>
    implements Runnable {
        private final NonBlockingLockManagerWithNewDesign<R> lockManager;

        public AcceptTask(NonBlockingLockManagerWithNewDesign<R> lockManager) {
            this.lockManager = lockManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: while (true) {
                switch (((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState) {
                    case Starting: {
                        this.awaitStateChange(ServiceRunState.Starting);
                        continue block17;
                    }
                    case Running: {
                        ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.lock();
                        try {
                            while (this.processRetryQueue()) {
                            }
                            this.awaitStateChange(ServiceRunState.Running);
                            continue block17;
                        }
                        finally {
                            ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.unlock();
                            continue block17;
                        }
                    }
                    case Shutdown: {
                        ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.lock();
                        try {
                            while (this.processRetryQueue()) {
                            }
                            if (((NonBlockingLockManagerWithNewDesign)this.lockManager).retryQueue.isEmpty()) {
                                if (INFO) {
                                    log.info((Object)"No more work.");
                                }
                                if (((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState.val < ServiceRunState.ShutdownNow.val) {
                                    ((NonBlockingLockManagerWithNewDesign)this.lockManager).setServiceRunState(ServiceRunState.ShutdownNow);
                                    continue block17;
                                }
                            }
                            this.awaitStateChange(ServiceRunState.Shutdown);
                            continue block17;
                        }
                        finally {
                            ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.unlock();
                            continue block17;
                        }
                    }
                    case ShutdownNow: {
                        ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.lock();
                        try {
                            if (INFO) {
                                log.info((Object)((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState);
                            }
                            this.cancelTasks(((NonBlockingLockManagerWithNewDesign)this.lockManager).retryQueue.iterator(), true);
                            this.lockManager.counters.nretry = 0;
                            if (((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState.val >= ServiceRunState.Halted.val) continue block17;
                            ((NonBlockingLockManagerWithNewDesign)this.lockManager).setServiceRunState(ServiceRunState.Halted);
                            if (!INFO) continue block17;
                            log.info((Object)((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState);
                            continue block17;
                        }
                        finally {
                            ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.unlock();
                            continue block17;
                        }
                    }
                    case Halted: {
                        if (INFO) {
                            log.info((Object)((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState);
                        }
                        ((NonBlockingLockManagerWithNewDesign)this.lockManager).service.shutdown();
                        return;
                    }
                }
                break;
            }
            throw new AssertionError();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitStateChange(ServiceRunState expected) {
            ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.lock();
            try {
                if (((NonBlockingLockManagerWithNewDesign)this.lockManager).serviceRunState != expected) {
                    return;
                }
                if (!((NonBlockingLockManagerWithNewDesign)this.lockManager).retryQueue.isEmpty()) {
                    return;
                }
                if (INFO) {
                    log.info((Object)"Waiting...");
                }
                ((NonBlockingLockManagerWithNewDesign)this.lockManager).stateChanged.await();
                if (INFO) {
                    log.info((Object)"Woke up...");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockManager).lock.unlock();
            }
        }

        private void cancelTasks(Iterator<LockFutureTask<R, ? extends Object>> itr, boolean mayInterruptIfRunning) {
            while (itr.hasNext()) {
                LockFutureTask<R, Object> t = itr.next();
                t.cancel(mayInterruptIfRunning);
                itr.remove();
            }
        }

        private boolean processRetryQueue() {
            LockFutureTask t;
            if (((NonBlockingLockManagerWithNewDesign)this.lockManager).waitsFor != null && ((NonBlockingLockManagerWithNewDesign)this.lockManager).waitsFor.isFull()) {
                return false;
            }
            int nchanged = 0;
            Iterator itr = ((NonBlockingLockManagerWithNewDesign)this.lockManager).retryQueue.iterator();
            while (itr.hasNext() && (t = (LockFutureTask)itr.next()).requestLocks()) {
                itr.remove();
                --this.lockManager.counters.nretry;
                ++nchanged;
            }
            if (INFO && nchanged > 0) {
                log.info((Object)("#nchanged=" + nchanged));
            }
            return nchanged > 0;
        }
    }

    public static class LockFutureTask<R extends Comparable<R>, T>
    extends FutureTaskMon<T> {
        final NonBlockingLockManagerWithNewDesign<R> lockService;
        private final R[] resource;
        private int ntries = 0;
        private final long acceptTime;
        private final LinkedHashSet<ResourceQueue<R, LockFutureTask<R, ? extends Object>>> lockedResources = new LinkedHashSet();
        private final Object callersTask;
        private volatile TaskRunState taskRunState = TaskRunState.New;
        private long lockWaitingTime;

        final TaskRunState getTaskRunState() {
            return this.taskRunState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTaskRunState(TaskRunState newval) {
            if (!((NonBlockingLockManagerWithNewDesign)this.lockService).lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (newval == null) {
                throw new IllegalArgumentException();
            }
            if (!this.taskRunState.isTransitionLegal(newval)) {
                log.error((Object)("Illegal state change: current=" + (Object)((Object)this.taskRunState) + ", newval=" + (Object)((Object)newval)));
                throw new IllegalStateException("current=" + (Object)((Object)this.taskRunState) + ", newval=" + (Object)((Object)newval));
            }
            try {
                TaskRunState oldval = this.taskRunState;
                if (oldval.isLockRequestsPosted() && !newval.isLockRequestsPosted()) {
                    boolean waiting;
                    boolean bl = waiting = !oldval.isRunning();
                    if (oldval.isRunning()) {
                        --this.lockService.counters.nrunningWithLocksHeld;
                    }
                    ((NonBlockingLockManagerWithNewDesign)this.lockService).releaseLocksForTask(this, waiting);
                }
            }
            finally {
                this.taskRunState = newval;
                if (!((NonBlockingLockManagerWithNewDesign)this.lockService).retryQueue.isEmpty()) {
                    ((NonBlockingLockManagerWithNewDesign)this.lockService).stateChanged.signal();
                }
            }
        }

        public R[] getResource() {
            return this.resource;
        }

        public long getLockLatency() {
            return this.lockWaitingTime;
        }

        @Override
        public String toString() {
            return super.toString() + "{resources=" + Arrays.toString(this.resource) + ", runState=" + (Object)((Object)this.taskRunState) + ", done=" + this.isDone() + ", cancelled=" + this.isCancelled() + ", ntries=" + this.ntries + "}";
        }

        private LockFutureTask(NonBlockingLockManagerWithNewDesign<R> lockService, R[] resource, Callable<T> task) {
            super(task);
            if (lockService == null) {
                throw new IllegalArgumentException();
            }
            this.lockService = lockService;
            this.resource = resource;
            this.callersTask = task;
            this.acceptTime = System.nanoTime();
        }

        private LockFutureTask(NonBlockingLockManagerWithNewDesign<R> lockService, R[] resources, Runnable task, T val) {
            super(task, val);
            if (lockService == null) {
                throw new IllegalArgumentException();
            }
            this.lockService = lockService;
            this.resource = resources;
            this.callersTask = task;
            this.acceptTime = System.nanoTime();
        }

        protected LockFutureTask<R, T> acceptTask() {
            if (!((NonBlockingLockManagerWithNewDesign)this.lockService).lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            switch (((NonBlockingLockManagerWithNewDesign)this.lockService).serviceRunState) {
                case Shutdown: 
                case Running: {
                    if (this.requestLocks()) {
                        return this;
                    }
                    this.setTaskRunState(TaskRunState.Retry);
                    ((NonBlockingLockManagerWithNewDesign)this.lockService).retryQueue.add(this);
                    ++this.lockService.counters.nretry;
                    return this;
                }
            }
            throw new IllegalStateException(((NonBlockingLockManagerWithNewDesign)this.lockService).serviceRunState.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLocksHeld() {
            ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.lock();
            try {
                boolean bl = ((NonBlockingLockManagerWithNewDesign)this.lockService).holdsAllLocks(this);
                return bl;
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.unlock();
            }
        }

        private boolean requestLocks() {
            if (!((NonBlockingLockManagerWithNewDesign)this.lockService).lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.isCancelled()) {
                return true;
            }
            if (((NonBlockingLockManagerWithNewDesign)this.lockService).serviceRunState.tasksCancelled()) {
                this.cancel(true);
                return true;
            }
            int nvertices = -1;
            try {
                if (((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor != null) {
                    nvertices = ((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor.size();
                }
                if (((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor != null && ((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor.isFull()) {
                    if (INFO) {
                        log.info((Object)"Maximum multi-programming capacity.");
                    }
                    return false;
                }
                if (((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor != null) {
                    ((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor.lookup(this, true);
                }
                if (((NonBlockingLockManagerWithNewDesign)this.lockService).postLockRequests(this)) {
                    if (INFO) {
                        log.info((Object)("Task is ready to run: " + this));
                    }
                    this.setTaskRunState(TaskRunState.LocksReady);
                    ++this.lockService.counters.nready;
                    this.lockService.ready(this);
                } else {
                    this.setTaskRunState(TaskRunState.LocksRequested);
                    ++this.lockService.counters.nwaiting;
                }
                return true;
            }
            catch (Throwable t2) {
                int nafter;
                if (t2 instanceof DeadlockException) {
                    if (INFO) {
                        log.info((Object)("Deadlock: " + this + ", task=" + this));
                    }
                    if (++this.ntries < ((NonBlockingLockManagerWithNewDesign)this.lockService).maxLockTries) {
                        if (INFO) {
                            log.info((Object)("Will retry task: " + this));
                        }
                        return false;
                    }
                } else {
                    log.error((Object)("Internal error: " + this), t2);
                }
                this.setException(t2);
                if (((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor != null && nvertices != (nafter = ((NonBlockingLockManagerWithNewDesign)this.lockService).waitsFor.size())) {
                    throw new AssertionError((Object)("#vertices: before=" + nvertices + ", after=" + nafter));
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setException(Throwable t) {
            ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.lock();
            try {
                super.setException(t);
                if (this.taskRunState != TaskRunState.Halted) {
                    if (DEBUG) {
                        log.debug((Object)("Exception: " + this + ", cause=" + t), t);
                    }
                    ++this.lockService.counters.nerror;
                    if (this.taskRunState.isRunning()) {
                        --this.lockService.counters.nrunning;
                    }
                    this.setTaskRunState(TaskRunState.Halted);
                }
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.lock();
            try {
                boolean ret = super.cancel(mayInterruptIfRunning);
                if (this.taskRunState != TaskRunState.Halted) {
                    if (DEBUG) {
                        log.debug((Object)("Cancelled: " + this));
                    }
                    ++this.lockService.counters.ncancel;
                    if (this.taskRunState.isRunning()) {
                        --this.lockService.counters.nrunning;
                    }
                    this.setTaskRunState(TaskRunState.Halted);
                }
                boolean bl = ret;
                return bl;
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.callersTask instanceof AbstractTask && ((AbstractTask)this.callersTask).getTaskCounters() instanceof WriteTaskCounters) {
                long lockWaitingTime = System.nanoTime() - this.acceptTime;
                ((WriteTaskCounters)((AbstractTask)this.callersTask).getTaskCounters()).lockWaitingNanoTime.addAndGet(lockWaitingTime);
            }
            ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.lock();
            try {
                if (this.taskRunState == TaskRunState.LocksReady) {
                    this.setTaskRunState(TaskRunState.RunningWithLocks);
                    --this.lockService.counters.nready;
                    ++this.lockService.counters.nrunning;
                    ++this.lockService.counters.nrunningWithLocksHeld;
                    if (this.lockService.counters.nrunning > this.lockService.counters.maxRunning) {
                        this.lockService.counters.maxRunning = this.lockService.counters.nrunning;
                    }
                }
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.unlock();
            }
            if (DEBUG) {
                log.debug((Object)("Running: " + this));
            }
            try {
                super.run();
            }
            finally {
                ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.lock();
                try {
                    if (this.taskRunState.isRunning()) {
                        if (DEBUG) {
                            log.debug((Object)("Did run: " + this));
                        }
                        --this.lockService.counters.nrunning;
                        this.setTaskRunState(TaskRunState.Halted);
                    }
                }
                finally {
                    ((NonBlockingLockManagerWithNewDesign)this.lockService).lock.unlock();
                }
            }
        }
    }

    static enum TaskRunState {
        New(0, false, false),
        Retry(0, false, false),
        LocksRequested(1, true, false),
        LocksReady(1, true, false),
        RunningWithLocks(4, true, true),
        RunningReleasedLocks(5, false, true),
        Halted(9, false, false);

        private final int val;
        private final boolean lockRequestPosted;
        private final boolean running;

        public boolean isTransitionLegal(TaskRunState newval) {
            if (this == New) {
                if (newval == Retry) {
                    return true;
                }
                if (newval == LocksRequested) {
                    return true;
                }
                if (newval == LocksReady) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == Retry) {
                if (newval == LocksRequested) {
                    return true;
                }
                if (newval == LocksReady) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == LocksRequested) {
                if (newval == LocksReady) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == LocksReady) {
                if (newval == RunningWithLocks) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == RunningWithLocks) {
                if (newval == RunningReleasedLocks) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == RunningReleasedLocks) {
                if (newval == Halted) {
                    return true;
                }
            } else {
                throw new AssertionError((Object)("Unknown runState=" + (Object)((Object)this)));
            }
            return false;
        }

        private TaskRunState(int val, boolean lockRequestsPosted, boolean running) {
            this.val = val;
            this.lockRequestPosted = lockRequestsPosted;
            this.running = running;
        }

        public int get() {
            return this.val;
        }

        public boolean isLockRequestsPosted() {
            return this.lockRequestPosted;
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    protected static class Counters {
        public long nrejected;
        public long ncancel;
        public long nerror;
        public int nretry;
        public int nwaiting;
        public int nready;
        public int nrunning;
        public int nrunningWithLocksHeld;
        public int maxRunning;

        protected Counters() {
        }
    }

    private static class WeakRefResourceQueueInstrument
    extends Instrument<Double> {
        private final R resource;
        final /* synthetic */ NonBlockingLockManagerWithNewDesign this$0;

        public WeakRefResourceQueueInstrument(R resource) {
            this.this$0 = var1_1;
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            this.resource = resource;
        }

        @Override
        public void sample() {
            ResourceQueue queue = (ResourceQueue)this.this$0.resourceQueues.get(this.resource);
            if (queue == null) {
                this.setValue(0.0);
            } else {
                double averageQueueSize = queue.statisticsTask.getAverageQueueSize();
                this.setValue(averageQueueSize);
            }
        }
    }

    static enum ServiceRunState {
        Starting(0, false, true),
        Running(1, true, false),
        Shutdown(2, false, false),
        ShutdownNow(3, false, true),
        Halted(4, false, true);

        private final int val;
        private final boolean tasksAccepted;
        private final boolean tasksCancelled;

        private ServiceRunState(int val, boolean tasksAccepted, boolean tasksCancelled) {
            this.val = val;
            this.tasksAccepted = tasksAccepted;
            this.tasksCancelled = tasksCancelled;
        }

        public int value() {
            return this.val;
        }

        public boolean tasksAccepted() {
            return this.tasksAccepted;
        }

        public boolean tasksCancelled() {
            return this.tasksCancelled;
        }

        public boolean isTransitionLegal(ServiceRunState newval) {
            if (this == Starting) {
                if (newval == Running) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == Running) {
                if (newval == Shutdown) {
                    return true;
                }
                if (newval == ShutdownNow) {
                    return true;
                }
            } else if (this == Shutdown) {
                if (newval == ShutdownNow) {
                    return true;
                }
                if (newval == Halted) {
                    return true;
                }
            } else if (this == ShutdownNow && newval == Halted) {
                return true;
            }
            return false;
        }
    }
}

