/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import java.util.concurrent.TimeUnit;

public enum PeriodEnum {
    Minutes(60000L),
    Hours(3600000L),
    Days(86400000L);

    private long basePeriodMillis;

    private PeriodEnum(long basePeriodMillis) {
        this.basePeriodMillis = basePeriodMillis;
    }

    public long getPeriodMillis() {
        return this.basePeriodMillis;
    }

    public TimeUnit toTimeUnit() {
        switch (this) {
            case Minutes: {
                return TimeUnit.MINUTES;
            }
            case Hours: {
                return TimeUnit.HOURS;
            }
            case Days: {
                return TimeUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    public static PeriodEnum getValue(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        switch (unit) {
            case MINUTES: {
                return Minutes;
            }
            case HOURS: {
                return Hours;
            }
            case DAYS: {
                return Days;
            }
        }
        throw new UnsupportedOperationException("unit=" + (Object)((Object)unit));
    }
}

