/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.buf.remaining() == 0) {
            return -1;
        }
        byte b = this.buf.get();
        return 0xFF & b;
    }

    @Override
    public synchronized int read(byte[] a, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int remaining = this.buf.remaining();
        if (remaining == 0) {
            return -1;
        }
        int readLength = Math.min(remaining, len);
        int climit = this.buf.limit();
        this.buf.limit(this.buf.position() + readLength);
        this.buf.get(a, off, readLength);
        this.buf.limit(climit);
        return readLength;
    }
}

