/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.compression.CompressorRegistry;
import com.bigdata.io.compression.IRecordCompressor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class NOPRecordCompressor
implements IRecordCompressor,
Externalizable {
    protected static final Logger log = Logger.getLogger(CompressorRegistry.class);
    private static final long serialVersionUID = 7525025093457384099L;
    public static final transient NOPRecordCompressor INSTANCE = new NOPRecordCompressor();

    @Override
    public void compress(ByteBuffer bin, ByteBuffer out) {
        out.put(bin);
    }

    @Override
    public ByteBuffer compress(ByteBuffer bin) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("NOP compression " + bin.limit()));
        }
        return bin;
    }

    @Override
    public void compress(ByteBuffer buf, OutputStream os) {
        if (buf.hasArray()) {
            int off = buf.arrayOffset() + buf.position();
            int len = buf.remaining();
            this.compress(buf.array(), off, len, os);
            buf.position(buf.limit());
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void compress(byte[] bytes, OutputStream os) {
        this.compress(bytes, os);
    }

    @Override
    public void compress(byte[] bytes, int off, int len, OutputStream os) {
        try {
            os.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer decompress(ByteBuffer bin) {
        return bin;
    }

    @Override
    public ByteBuffer decompress(byte[] bin) {
        return ByteBuffer.wrap(bin);
    }

    @Override
    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput arg0) throws IOException {
    }
}

