/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.writecache;

import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.writecache.IBufferedWriter;
import com.bigdata.rwstore.RWStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicReference;

public class BufferedWrite {
    private final IBufferedWriter m_store;
    private final AtomicReference<IBufferAccess> m_data = new AtomicReference();
    private long m_startAddr = -1L;
    private long m_endAddr = 0L;
    private final RWStore.StoreCounters<?> m_storeCounters;
    private static final byte[] s_zeros = new byte[256];

    public BufferedWrite(IBufferedWriter store) throws InterruptedException {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        this.m_store = store;
        this.m_storeCounters = this.m_store.getStoreCounters();
        this.m_data.set(DirectBufferPool.INSTANCE.acquire());
    }

    public void release() throws InterruptedException {
        IBufferAccess tmp = this.m_data.get();
        if (tmp == null) {
            return;
        }
        if (this.m_data.compareAndSet(tmp, null)) {
            tmp.release();
        }
    }

    public synchronized int write(long offset, ByteBuffer data, IReopenChannel<FileChannel> opener) throws IOException {
        ++this.m_storeCounters.bufferDataWrites;
        int data_len = data.remaining();
        int slot_len = this.m_store.getSlotSize(data_len);
        int nwrites = 0;
        ByteBuffer m_data = this.m_data.get().buffer();
        if (slot_len > m_data.remaining()) {
            nwrites += this.flush(opener);
        }
        if (this.m_startAddr == -1L) {
            this.m_startAddr = this.m_endAddr = offset;
        } else if (this.m_endAddr != offset) {
            nwrites += this.flush(opener);
            this.m_startAddr = this.m_endAddr = offset;
        }
        m_data.put(data);
        for (int padding = slot_len - data_len; padding > 0; padding -= s_zeros.length) {
            if (padding > s_zeros.length) {
                m_data.put(s_zeros);
                continue;
            }
            m_data.put(s_zeros, 0, padding);
            break;
        }
        this.m_endAddr += (long)slot_len;
        long pos = this.m_endAddr - this.m_startAddr;
        m_data.position((int)pos);
        return nwrites;
    }

    public synchronized int flush(IReopenChannel<FileChannel> opener) throws IOException {
        ByteBuffer m_data = this.m_data.get().buffer();
        if (m_data.position() == 0) {
            return 0;
        }
        this.m_storeCounters.bufferDataBytes += (long)m_data.position();
        m_data.flip();
        int nwrites = FileChannelUtility.writeAll(opener, m_data, this.m_startAddr);
        this.m_storeCounters.bufferFileWrites += (long)nwrites;
        this.reset();
        return nwrites;
    }

    public synchronized void reset() {
        IBufferAccess tmp = this.m_data.get();
        if (tmp == null) {
            return;
        }
        ByteBuffer m_data = tmp.buffer();
        m_data.clear();
        this.m_startAddr = -1L;
        this.m_endAddr = 0L;
    }

    public String getStats(StringBuffer buf, boolean reset) {
        String ret = "BufferedWrites, data: " + this.m_storeCounters.bufferDataWrites + ", file: " + this.m_storeCounters.bufferFileWrites + ", bytes: " + this.m_storeCounters.bufferDataBytes;
        if (buf != null) {
            buf.append(ret + "\n");
        }
        if (reset) {
            this.m_storeCounters.bufferFileWrites = 0L;
            this.m_storeCounters.bufferDataWrites = 0L;
            this.m_storeCounters.bufferDataBytes = 0L;
        }
        return ret;
    }
}

