/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.service.AbstractTransactionService;
import java.io.File;
import java.util.Properties;

public class RemoveDeferredFreesFromCommitRecords {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: <storename>");
            return;
        }
        File f = new File(args[0]);
        if (!f.exists()) {
            System.err.println("File not found: " + args[0]);
            return;
        }
        Properties props = new Properties();
        props.setProperty(Journal.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        props.setProperty(Journal.Options.FILE, args[0]);
        props.setProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "9223372036854775807");
        MyJournal jnl = new MyJournal(props);
        try {
            IIndex commitRecordIndex = jnl.getMutableCommitIndexManager();
            IndexMetadata metadata = commitRecordIndex.getIndexMetadata();
            byte[] fromKey = metadata.getTupleSerializer().serializeKey(0L);
            byte[] toKey = metadata.getTupleSerializer().serializeKey(System.currentTimeMillis());
            jnl.removeCommitRecordEntries(fromKey, toKey);
            jnl.commit();
        }
        finally {
            jnl.shutdownNow();
        }
    }

    static class MyJournal
    extends Journal {
        MyJournal(Properties props) {
            super(props);
        }

        IIndex getMutableCommitIndexManager() {
            return this.getCommitRecordIndex(this.getRootBlockView().getCommitRecordIndexAddr(), false);
        }
    }
}

