/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.changesets;

import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Iterator;

public class StatementWriter {
    public static long addStatements(AbstractTripleStore database, AbstractTripleStore statementStore, boolean copyOnly, IElementFilter<ISPO> filter, IChunkedOrderedIterator<ISPO> itr, IChangeLog changeLog) {
        long n = 0L;
        if (itr.hasNext()) {
            ISPO[] stmts = new SPO[database.getChunkCapacity()];
            int i = 0;
            while ((i = StatementWriter.nextChunk(itr, stmts)) > 0) {
                n += StatementWriter.addStatements(database, statementStore, copyOnly, filter, stmts, i, changeLog);
            }
        }
        return n;
    }

    private static long addStatements(AbstractTripleStore database, AbstractTripleStore statementStore, boolean copyOnly, IElementFilter<ISPO> filter, ISPO[] stmts, int numStmts, IChangeLog changeLog) {
        long n = database.addStatements(statementStore, copyOnly, new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), filter);
        block5: for (int i = 0; i < numStmts; ++i) {
            if (!stmts[i].isModified() || changeLog == null) continue;
            switch (stmts[i].getModified()) {
                case INSERTED: {
                    changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.INSERTED));
                    continue block5;
                }
                case UPDATED: {
                    changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.UPDATED));
                    continue block5;
                }
                case REMOVED: {
                    throw new AssertionError();
                }
            }
        }
        return n;
    }

    public static long removeStatements(AbstractTripleStore database, IChunkedOrderedIterator<ISPO> itr, boolean computeClosureForStatementIdentifiers, IChangeLog changeLog) {
        long n = 0L;
        if (itr.hasNext()) {
            ISPO[] stmts = new ISPO[database.getChunkCapacity()];
            int i = 0;
            while ((i = StatementWriter.nextChunk(itr, stmts)) > 0) {
                n += StatementWriter.removeStatements(database, stmts, i, computeClosureForStatementIdentifiers, changeLog);
            }
        }
        return n;
    }

    public static long removeStatements(AbstractTripleStore database, ISPO[] stmts, int numStmts, boolean computeClosureForStatementIdentifiers, IChangeLog changeLog) {
        long n = database.removeStatements(new ChunkedArrayIterator<ISPO>(numStmts, stmts, null), computeClosureForStatementIdentifiers);
        for (int i = 0; i < numStmts; ++i) {
            if (!stmts[i].isModified()) continue;
            stmts[i].setModified(ModifiedEnum.REMOVED);
            changeLog.changeEvent(new ChangeRecord(stmts[i], ChangeAction.REMOVED));
        }
        return n;
    }

    private static int nextChunk(Iterator<ISPO> itr, ISPO[] stmts) {
        assert (stmts != null && stmts.length > 0);
        int i = 0;
        while (itr.hasNext()) {
            stmts[i++] = itr.next();
            if (i != stmts.length) continue;
            return i;
        }
        return i;
    }
}

