/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openrdf.model.Value;

public class MergeSortIterator
implements Iterator<Value> {
    private final int n;
    private final Iterator<Value>[] sourceIterator;
    private final Value[] sourceTuple;
    private int current = -1;

    public MergeSortIterator(Iterator<Value>[] sourceIterators) {
        assert (sourceIterators != null);
        assert (sourceIterators.length > 0);
        this.n = sourceIterators.length;
        for (int i = 0; i < this.n; ++i) {
            assert (sourceIterators[i] != null);
        }
        this.sourceIterator = sourceIterators;
        this.sourceTuple = new Value[this.n];
    }

    @Override
    public boolean hasNext() {
        if (this.current != -1) {
            return true;
        }
        int nexhausted = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.sourceTuple[i] != null) continue;
            if (this.sourceIterator[i].hasNext()) {
                this.sourceTuple[i] = this.sourceIterator[i].next();
                continue;
            }
            ++nexhausted;
        }
        if (nexhausted == this.n) {
            return false;
        }
        assert (this.current == -1);
        Value key = null;
        for (int i = 0; i < this.n; ++i) {
            if (this.sourceTuple[i] == null) continue;
            if (this.current == -1) {
                this.current = i;
                key = this.sourceTuple[i];
                assert (key != null);
                continue;
            }
            Value tmp = this.sourceTuple[i];
            int ret = this.compare(tmp, key);
            if (ret >= 0) continue;
            this.current = i;
            key = tmp;
        }
        assert (this.current != -1);
        return true;
    }

    @Override
    public Value next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.consumeLookaheadTuple();
    }

    private Value consumeLookaheadTuple() {
        Value t = this.sourceTuple[this.current];
        this.clearCurrent();
        return t;
    }

    protected void clearCurrent() {
        assert (this.current != -1);
        Value key = this.sourceTuple[this.current];
        for (int i = this.current + 1; i < this.n; ++i) {
            Value tmp;
            int ret;
            if (this.sourceTuple[i] == null || (ret = this.compare(key, tmp = this.sourceTuple[i])) != 0) continue;
            this.sourceTuple[i] = null;
        }
        this.sourceTuple[this.current] = null;
        this.current = -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int compare(Value a, Value b) {
        return IVUtility.compare((IV)a, (IV)b);
    }
}

