/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.bd;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.graph.BinderBase;
import com.bigdata.rdf.graph.EdgesEnum;
import com.bigdata.rdf.graph.Factory;
import com.bigdata.rdf.graph.FrontierEnum;
import com.bigdata.rdf.graph.IBinder;
import com.bigdata.rdf.graph.IGASContext;
import com.bigdata.rdf.graph.IGASScheduler;
import com.bigdata.rdf.graph.IGASState;
import com.bigdata.rdf.graph.IPredecessor;
import com.bigdata.rdf.graph.impl.BaseGASProgram;
import com.bigdata.rdf.internal.IV;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class PATHS
extends BaseGASProgram<VS, ES, Void>
implements IPredecessor<VS, ES, Void> {
    private static final Logger log = Logger.getLogger(PATHS.class);
    private static final Factory<Value, VS> vertexStateFactory = new Factory<Value, VS>(){

        public VS initialValue(Value value) {
            return new VS();
        }
    };

    public Factory<Value, VS> getVertexStateFactory() {
        return vertexStateFactory;
    }

    public Factory<Statement, ES> getEdgeStateFactory() {
        return null;
    }

    public FrontierEnum getInitialFrontierEnum() {
        return FrontierEnum.SingleVertex;
    }

    public EdgesEnum getGatherEdges() {
        return EdgesEnum.NoEdges;
    }

    public EdgesEnum getScatterEdges() {
        return EdgesEnum.OutEdges;
    }

    public void initVertex(IGASContext<VS, ES, Void> ctx, IGASState<VS, ES, Void> state, Value u) {
        ((VS)state.getState(u)).visit(0, null, null);
    }

    public Void gather(IGASState<VS, ES, Void> state, Value u, Statement e) {
        throw new UnsupportedOperationException();
    }

    public Void sum(IGASState<VS, ES, Void> state, Void left, Void right) {
        throw new UnsupportedOperationException();
    }

    public VS apply(IGASState<VS, ES, Void> state, Value u, Void sum) {
        return null;
    }

    public boolean isChanged(IGASState<VS, ES, Void> state, Value u) {
        return true;
    }

    public void scatter(IGASState<VS, ES, Void> state, IGASScheduler sch, Value u, Statement e) {
        Value v = state.getOtherVertex(u, e);
        VS otherState = (VS)state.getState(v);
        int otherDepth = otherState.depth();
        if (otherState.visit(state.round() + 1, u, e.getPredicate())) {
            sch.schedule(v);
        }
    }

    public boolean nextRound(IGASContext<VS, ES, Void> ctx) {
        return true;
    }

    public List<IBinder<VS, ES, Void>> getBinderList() {
        List tmp = super.getBinderList();
        tmp.add(new BinderBase<VS, ES, Void>(){

            public int getIndex() {
                return 1;
            }

            public Value bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u) {
                return vf.createLiteral(((VS)state.getState(u)).depth.get());
            }
        });
        tmp.add(new IBinder<VS, ES, Void>(){

            public int getIndex() {
                return 2;
            }

            public List<Value> bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u, IVariable<?>[] outVars, IBindingSet bs) {
                VS vs = (VS)state.getState(u);
                return new LinkedList<Value>(vs.predecessors().keySet());
            }
        });
        tmp.add(new IBinder<VS, ES, Void>(){

            public int getIndex() {
                return 3;
            }

            public List<Value> bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u, IVariable<?>[] outVars, IBindingSet bs) {
                IV predVal;
                IVariable<?> var = outVars[2];
                if (!bs.isBound(var)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"no predecessors");
                    }
                    return Collections.EMPTY_LIST;
                }
                IV predIV = (IV)bs.get(var).get();
                if (predIV instanceof Value) {
                    predVal = predIV;
                } else if (predIV.hasValue()) {
                    predVal = predIV.getValue();
                } else {
                    throw new RuntimeException("FIXME");
                }
                VS vs = (VS)state.getState(u);
                return new LinkedList<Value>((Collection)vs.predecessors().get(predVal));
            }
        });
        tmp.add(new IBinder<VS, ES, Void>(){

            public int getIndex() {
                return 4;
            }

            public List<Value> bind(ValueFactory vf, IGASState<VS, ES, Void> state, Value u, IVariable<?>[] outVars, IBindingSet bs) {
                IV predVal;
                IVariable<?> var = outVars[2];
                if (!bs.isBound(var)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"no predecessors");
                    }
                    return Collections.EMPTY_LIST;
                }
                IV predIV = (IV)bs.get(var).get();
                if (predIV instanceof Value) {
                    predVal = predIV;
                } else if (predIV.hasValue()) {
                    predVal = predIV.getValue();
                } else {
                    throw new RuntimeException("FIXME");
                }
                return Arrays.asList(vf.createLiteral(((VS)state.getState((Value)predVal)).depth.get()));
            }
        });
        return tmp;
    }

    public void prunePaths(IGASContext<VS, ES, Void> ctx, Value[] targetVertices) {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (targetVertices == null) {
            throw new IllegalArgumentException();
        }
        IGASState gasState = ctx.getGASState();
        HashSet<Value> retainSet = new HashSet<Value>();
        for (Value v : targetVertices) {
            if (!gasState.isVisited(v)) continue;
            retainSet.add(v);
            this.visitPredecessors((IGASState<VS, ES, Void>)gasState, v, retainSet);
        }
        gasState.retainAll(retainSet);
    }

    protected void visitPredecessors(IGASState<VS, ES, Void> gasState, Value v, Set<Value> retainSet) {
        VS currentState = (VS)gasState.getState(v);
        for (Value pred : currentState.predecessors().keySet()) {
            if (retainSet.contains(pred)) continue;
            retainSet.add(pred);
            this.visitPredecessors(gasState, pred, retainSet);
        }
    }

    public static interface Bindings
    extends BaseGASProgram.Bindings {
        public static final int DEPTH = 1;
        public static final int PREDECESSORS = 2;
        public static final int EDGES = 3;
        public static final int PRED_DEPTH = 4;
    }

    public static class ES {
    }

    public static class VS {
        private final AtomicInteger depth = new AtomicInteger(-1);
        private final Map<Value, Set<URI>> predecessors = Collections.synchronizedMap(new LinkedHashMap());

        public int depth() {
            return this.depth.get();
        }

        public Map<Value, Set<URI>> predecessors() {
            return this.predecessors;
        }

        public synchronized void addPredecessor(Value pred, URI edge) {
            Set<URI> edges = this.predecessors.get(pred);
            if (edges == null) {
                edges = new LinkedHashSet<URI>();
                this.predecessors.put(pred, edges);
            }
            edges.add(edge);
        }

        public synchronized boolean visit(int depth, Value pred, URI edge) {
            boolean ret = false;
            if (this.depth.compareAndSet(-1, depth)) {
                ret = true;
            }
            if (pred != null && this.depth() > 0 && this.depth() == depth) {
                this.addPredecessor(pred, edge);
            }
            return ret;
        }

        public String toString() {
            return "{depth=" + this.depth() + "}";
        }
    }
}

