/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class BackchainOwlSameAsIterator
implements IChunkedOrderedIterator<ISPO> {
    protected static final Logger log = Logger.getLogger(BackchainOwlSameAsIterator.class);
    protected AbstractTripleStore db;
    protected final boolean copyOnly = true;
    protected IV sameAs;
    final int chunkSize = 100;
    protected IChunkedOrderedIterator<ISPO> src;

    public BackchainOwlSameAsIterator(IChunkedOrderedIterator<ISPO> src, AbstractTripleStore db, IV sameAs) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (sameAs == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.db = db;
        this.sameAs = sameAs;
    }

    protected Set<IV> getSelfAndSames(IV iv) {
        TreeSet<IV> selfAndSames = new TreeSet<IV>();
        selfAndSames.add(iv);
        this.getSames(iv, selfAndSames);
        return selfAndSames;
    }

    protected Set<IV> getSames(IV iv) {
        TreeSet<IV> sames = new TreeSet<IV>();
        sames.add(iv);
        this.getSames(iv, sames);
        sames.remove(iv);
        return sames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSames(IV id, Set<IV> sames) {
        IV same;
        try (IChunkedOrderedIterator<ISPO> it = this.db.getAccessPath(id, this.sameAs, null).iterator();){
            while (it.hasNext()) {
                same = ((ISPO)it.next()).o();
                if (sames.contains(same)) continue;
                sames.add(same);
                this.getSames(same, sames);
            }
        }
        it = this.db.getAccessPath(null, this.sameAs, id).iterator();
        try {
            while (it.hasNext()) {
                same = ((ISPO)it.next()).s();
                if (sames.contains(same)) continue;
                sames.add(same);
                this.getSames(same, sames);
            }
        }
        finally {
            it.close();
        }
    }

    protected TempTripleStore createTempTripleStore() {
        Properties props = this.db.getProperties();
        props.setProperty(AbstractTripleStore.Options.LEXICON, "false");
        props.setProperty(AbstractTripleStore.Options.ONE_ACCESS_PATH, "true");
        props.setProperty(AbstractTripleStore.Options.BLOOM_FILTER, "false");
        return new TempTripleStore(this.db.getIndexManager().getTempStore(), props, this.db);
    }

    protected void dumpSPO(ISPO spo) {
    }
}

