/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IExtensionFactory;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.extensions.DerivedNumericsExtension;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.extensions.XSDStringExtension;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.service.GeoSpatialConfig;
import java.util.Collection;
import java.util.LinkedList;

public class DefaultExtensionFactory
implements IExtensionFactory {
    private final Collection<IExtension> extensions = new LinkedList<IExtension>();
    private volatile IExtension[] extensionsArray;

    @Override
    public void init(IDatatypeURIResolver resolver, ILexiconConfiguration<BigdataValue> config) {
        this.extensions.add(new DerivedNumericsExtension(resolver));
        if (config.isGeoSpatial()) {
            GeoSpatialConfig.getInstance().init(config.getGeoSpatialConfig());
            this.extensions.add(new GeoSpatialLiteralExtension(resolver));
        }
        if (config.isInlineDateTimes()) {
            this.extensions.add(new DateTimeExtension(resolver, config.getInlineDateTimesTimeZone()));
        }
        if (config.getMaxInlineStringLength() > 0) {
            this.extensions.add(new XSDStringExtension(resolver, config.getMaxInlineStringLength()));
        }
        this._init(resolver, config, this.extensions);
        this.extensionsArray = this.extensions.toArray(new IExtension[this.extensions.size()]);
    }

    protected void _init(IDatatypeURIResolver resolver, ILexiconConfiguration<BigdataValue> config, Collection<IExtension> extensions) {
    }

    @Override
    public IExtension[] getExtensions() {
        return this.extensionsArray;
    }
}

