/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public enum VTE {
    URI(0),
    BNODE(1),
    LITERAL(2),
    STATEMENT(3);

    final byte v;

    private VTE(byte flags) {
        this.v = flags;
    }

    public final byte v() {
        return this.v;
    }

    public static VTE valueOf(byte b) {
        switch (b & 3) {
            case 0: {
                return URI;
            }
            case 1: {
                return BNODE;
            }
            case 2: {
                return LITERAL;
            }
            case 3: {
                return STATEMENT;
            }
        }
        throw new AssertionError();
    }

    public final char getCharCode() {
        if (this.v == VTE.URI.v) {
            return 'U';
        }
        if (this.v == VTE.LITERAL.v) {
            return 'L';
        }
        if (this.v == VTE.BNODE.v) {
            return 'B';
        }
        if (this.v == VTE.STATEMENT.v) {
            return 'S';
        }
        throw new AssertionError();
    }

    public static final VTE valueOf(char c) {
        switch (c) {
            case 'U': {
                return URI;
            }
            case 'L': {
                return LITERAL;
            }
            case 'B': {
                return BNODE;
            }
            case 'S': {
                return STATEMENT;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final VTE valueOf(Value v) {
        if (v instanceof URI) {
            return URI;
        }
        if (v instanceof Literal) {
            return LITERAL;
        }
        if (v instanceof BNode) {
            return BNODE;
        }
        throw new IllegalArgumentException();
    }
}

