/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.CoordinateDDM;
import com.bigdata.rdf.internal.gis.CoordinateDMS;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordinateDD
implements ICoordinate {
    public final double northSouth;
    public final double eastWest;
    private static final double MAX_NORTH_SOUTH = 90.0;
    private static final double MIN_NORTH_SOUTH = -90.0;
    private static final double MAX_EAST_WEST = 180.0;
    private static final double MIN_EAST_WEST = -180.0;
    private static final DecimalFormat FMT_DECIMAL_DEGREES = new DecimalFormat();
    static final String regex_lat = "([-+]?\\d{1,2}\\.\\d{3,})[\ufffd*]?";
    static final String regex_long = "([-+]?\\d{1,3}\\.\\d{3,})[\ufffd*]?";
    static final Pattern pattern_dd;
    static final int group_degreesNorth = 3;
    static final int group_degreesEast = 5;

    public CoordinateDD(double northSouth, double eastWest) {
        this(northSouth, eastWest, false);
    }

    public CoordinateDD(double northSouth, double eastWest, boolean adjustToMinMax) {
        if (northSouth < -90.0 || northSouth > 90.0) {
            if (adjustToMinMax) {
                northSouth = northSouth < -90.0 ? -90.0 : 90.0;
            } else {
                throw new IllegalArgumentException("NorthSouth: " + FMT_DECIMAL_DEGREES.format(northSouth));
            }
        }
        if (eastWest < -180.0 || eastWest > 180.0) {
            if (adjustToMinMax) {
                eastWest = eastWest < -180.0 ? -180.0 : 180.0;
            } else {
                throw new IllegalArgumentException("EastWest: " + FMT_DECIMAL_DEGREES.format(eastWest));
            }
        }
        this.northSouth = northSouth;
        this.eastWest = eastWest;
    }

    public String toString() {
        return FMT_DECIMAL_DEGREES.format(this.northSouth) + "," + FMT_DECIMAL_DEGREES.format(this.eastWest);
    }

    public static CoordinateDD parse(String text) throws ParseException {
        Matcher m = pattern_dd.matcher(text);
        if (m.matches()) {
            double northSouth = Double.parseDouble(m.group(3));
            double eastWest = Double.parseDouble(m.group(5));
            return new CoordinateDD(northSouth, eastWest, false);
        }
        throw new ParseException("Not decimal degrees: [" + text + "]", 0);
    }

    @Override
    public boolean equals(ICoordinate o) {
        if (o instanceof CoordinateDD) {
            return this.equals((CoordinateDD)o);
        }
        return false;
    }

    public boolean equals(CoordinateDD o) {
        return this.northSouth == o.northSouth && this.eastWest == o.eastWest;
    }

    @Override
    public CoordinateDMS toDMS() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double distance(ICoordinate o, ICoordinate.UNITS units) {
        return CoordinateUtility.distance(this, o.toDD(), units);
    }

    @Override
    public CoordinateDDM toDDM() {
        return null;
    }

    @Override
    public CoordinateDD toDD() {
        return this;
    }

    static {
        FMT_DECIMAL_DEGREES.setPositivePrefix("+");
        FMT_DECIMAL_DEGREES.setNegativePrefix("-");
        FMT_DECIMAL_DEGREES.setMinimumFractionDigits(5);
        pattern_dd = Pattern.compile("^((([-+]?\\d{1,2}\\.\\d{3,})[\ufffd*]?(\\s?[/,]?\\s?)([-+]?\\d{1,3}\\.\\d{3,})[\ufffd*]?))$");
    }
}

