/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.UUID;
import org.openrdf.model.Literal;

public class UUIDLiteralIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, UUID>
implements Literal {
    private static final long serialVersionUID = 6411134650187983925L;
    private final UUID value;

    @Override
    public IV<V, UUID> clone(boolean clearCache) {
        UUIDLiteralIV tmp = new UUIDLiteralIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public UUIDLiteralIV(UUID value) {
        super(DTE.UUID);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public final UUID getInlineValue() {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = (BigdataLiteral)f.createLiteral(this.value.toString(), DTE.UUID.getDatatypeURI());
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UUIDLiteralIV) {
            return this.value.equals(((UUIDLiteralIV)o).value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int byteLength() {
        return 17;
    }

    @Override
    public int _compareTo(IV o) {
        return this.value.compareTo(((UUIDLiteralIV)o).value);
    }
}

