/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSDUnsignedShortIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Integer> {
    private static final long serialVersionUID = 1L;
    private final short value;
    private static final short UNSIGNED_ZERO = Short.MIN_VALUE;

    public short rawValue() {
        return this.value;
    }

    public final int promote() {
        return XSDUnsignedShortIV.promote(this.value);
    }

    public static int promote(short val) {
        int v = val - Short.MIN_VALUE;
        return v;
    }

    @Override
    public IV<V, Integer> clone(boolean clearCache) {
        XSDUnsignedShortIV tmp = new XSDUnsignedShortIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDUnsignedShortIV(short value) {
        super(DTE.XSDUnsignedShort);
        this.value = value;
    }

    @Override
    public final Integer getInlineValue() {
        return this.promote();
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = f.createLiteral(this.value, true);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final long longValue() {
        return this.promote();
    }

    @Override
    public boolean booleanValue() {
        return this.value != Short.MIN_VALUE;
    }

    @Override
    public byte byteValue() {
        return (byte)this.promote();
    }

    @Override
    public double doubleValue() {
        return this.promote();
    }

    @Override
    public float floatValue() {
        return this.promote();
    }

    @Override
    public int intValue() {
        return this.promote();
    }

    @Override
    public short shortValue() {
        return (short)this.promote();
    }

    @Override
    public String stringValue() {
        return Integer.toString(this.promote());
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.promote());
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.promote());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDUnsignedShortIV) {
            return this.value == ((XSDUnsignedShortIV)o).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public int byteLength() {
        return 3;
    }

    @Override
    public int _compareTo(IV o) {
        XSDUnsignedShortIV t = (XSDUnsignedShortIV)o;
        return this.value == t.value ? 0 : (this.value < t.value ? -1 : 1);
    }
}

