/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.AssignTermId;
import com.bigdata.rdf.lexicon.LexiconKeyBuilder;
import com.bigdata.rdf.lexicon.Term2IdTupleSerializer;
import com.bigdata.rdf.lexicon.Term2IdWriteProc;
import com.bigdata.rdf.lexicon.WriteTaskStats;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.pipeline.KVOList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class Term2IdWriteTask
implements Callable<KVO<BigdataValue>[]> {
    private static final transient Logger log = Logger.getLogger(Term2IdWriteTask.class);
    private final IIndex termIdIndex;
    private final boolean readOnly;
    private final boolean storeBlankNodes;
    private final int termIdBitsToReverse;
    private final int numTerms;
    private final BigdataValue[] terms;
    private final WriteTaskStats stats;

    public Term2IdWriteTask(IIndex termIdIndex, boolean readOnly, boolean storeBlankNodes, int termIdBitsToReverse, int numTerms, BigdataValue[] terms, WriteTaskStats stats) {
        if (termIdIndex == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        if (numTerms < 0 || numTerms > terms.length) {
            throw new IllegalArgumentException();
        }
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        this.termIdIndex = termIdIndex;
        this.readOnly = readOnly;
        this.storeBlankNodes = storeBlankNodes;
        this.termIdBitsToReverse = termIdBitsToReverse;
        this.numTerms = numTerms;
        this.terms = terms;
        this.stats = stats;
    }

    @Override
    public KVO<BigdataValue>[] call() throws Exception {
        int ndistinct = 0;
        long _begin = System.currentTimeMillis();
        Term2IdTupleSerializer tupleSer = (Term2IdTupleSerializer)this.termIdIndex.getIndexMetadata().getTupleSerializer();
        Object[] b = this.generateSortKeys(tupleSer.getLexiconKeyBuilder(), this.terms, this.numTerms);
        this.stats.keyGenTime.add(System.currentTimeMillis() - _begin);
        _begin = System.currentTimeMillis();
        Arrays.sort(b);
        this.stats.keySortTime.add(System.currentTimeMillis() - _begin);
        _begin = System.currentTimeMillis();
        byte[][] keys = new byte[this.numTerms][];
        KVO[] a = new KVO[this.numTerms];
        for (int i = 0; i < this.numTerms; ++i) {
            if (((BigdataValue)((KVO)b[i]).obj).getIV() != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("term identifier already assigned: " + ((KVO)b[i]).obj));
                continue;
            }
            if (i > 0 && ((KVO)b[i - 1]).obj == ((KVO)b[i]).obj) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("duplicate term reference: " + ((KVO)b[i]).obj));
                continue;
            }
            a[ndistinct] = b[i];
            keys[ndistinct] = ((KVO)b[i]).key;
            ++ndistinct;
        }
        if (ndistinct == 0) {
            return new KVO[0];
        }
        Term2IdWriteProc.Term2IdWriteProcConstructor ctor = new Term2IdWriteProc.Term2IdWriteProcConstructor(this.readOnly, this.storeBlankNodes, this.termIdBitsToReverse);
        this.termIdIndex.submit(0, ndistinct, keys, null, ctor, new Term2IdWriteProcResultHandler(a, this.readOnly, this.stats.nunknown));
        this.stats.forwardIndexTime = System.currentTimeMillis() - _begin;
        this.stats.indexTime.addAndGet(this.stats.forwardIndexTime);
        this.stats.ndistinct.addAndGet(ndistinct);
        return KVO.dense(a, ndistinct);
    }

    private final KVO<BigdataValue>[] generateSortKeys(LexiconKeyBuilder keyBuilder, BigdataValue[] terms, int numTerms) {
        KVO[] a = new KVO[numTerms];
        for (int i = 0; i < numTerms; ++i) {
            BigdataValue term = terms[i];
            a[i] = new KVO<BigdataValue>(keyBuilder.value2Key(term), null, term);
        }
        return a;
    }

    private static class Term2IdWriteProcResultHandler
    implements IResultHandler<Term2IdWriteProc.Result, Void> {
        private final KVO<BigdataValue>[] a;
        private final boolean readOnly;
        private final AtomicInteger nunknown;

        public Term2IdWriteProcResultHandler(KVO<BigdataValue>[] a, boolean readOnly, AtomicInteger nunknown) {
            if (a == null) {
                throw new IllegalArgumentException();
            }
            if (nunknown == null) {
                throw new IllegalArgumentException();
            }
            this.a = a;
            this.readOnly = readOnly;
            this.nunknown = nunknown;
        }

        @Override
        public void aggregate(Term2IdWriteProc.Result result, Split split) {
            int i = split.fromIndex;
            int j = 0;
            while (i < split.toIndex) {
                IV termId = result.ivs[j];
                if (termId == null) {
                    if (!this.readOnly) {
                        throw new AssertionError();
                    }
                    this.nunknown.incrementAndGet();
                } else {
                    KVOList tmp;
                    ((BigdataValue)this.a[i].obj).setIV(termId);
                    if (this.a[i] instanceof KVOList && !(tmp = (KVOList)this.a[i]).isDuplicateListEmpty()) {
                        tmp.map(new AssignTermId(termId));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("termId=" + termId + ", term=" + this.a[i].obj));
                    }
                }
                ++i;
                ++j;
            }
        }

        @Override
        public Void getResult() {
            return null;
        }
    }
}

