/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.rio.BasicRioLoader;
import com.bigdata.rdf.rio.IStatementBuffer;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class PresortRioLoader
extends BasicRioLoader
implements RDFHandler {
    protected final IStatementBuffer<?> buffer;
    private final boolean flush;
    private BigdataURI defaultGraphURI = null;

    public PresortRioLoader(IStatementBuffer<?> buffer) {
        this(buffer, true);
    }

    public PresortRioLoader(IStatementBuffer<?> buffer, boolean flush) {
        super(buffer.getDatabase().getValueFactory());
        this.buffer = buffer;
        this.flush = flush;
    }

    @Override
    protected void success() {
        if (this.buffer != null && this.flush) {
            this.buffer.flush();
        }
    }

    @Override
    protected void error(Exception ex) {
        if (this.buffer != null) {
            this.buffer.reset();
        }
        super.error(ex);
    }

    @Override
    public RDFHandler newRDFHandler() {
        this.defaultGraphURI = null != this.defaultGraph && this.buffer.getDatabase().isQuads() ? this.buffer.getDatabase().getValueFactory().createURI(this.defaultGraph) : null;
        return this;
    }

    public void handleStatement(Statement stmt) {
        Resource graph;
        if (log.isDebugEnabled()) {
            log.debug((Object)stmt);
        }
        if (null == (graph = stmt.getContext()) && null != this.defaultGraphURI) {
            graph = this.defaultGraphURI;
        }
        this.buffer.add(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), graph);
        ++this.stmtsAdded;
        if (this.stmtsAdded % 100000L == 0L) {
            this.notifyListeners();
        }
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleComment(String arg0) throws RDFHandlerException {
    }

    public void handleNamespace(String arg0, String arg1) throws RDFHandlerException {
    }

    public void startRDF() throws RDFHandlerException {
    }
}

