/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.striterator.IChunkedIterator;
import java.io.Serializable;

public abstract class AbstractRuleDistinctTermScan
extends Rule {
    private final IVariable<IV> h;
    private final SPOKeyOrder keyOrder;
    private final IRuleTaskFactory taskFactory;

    public AbstractRuleDistinctTermScan(String name, SPOPredicate head, SPOPredicate[] body, IConstraint[] constraints) {
        super(name, head, body, constraints);
        assert (head.getVariableCount() == 1);
        assert (body.length == 1);
        assert (body[0].getVariableCount() == body[0].arity());
        if (head.s().isVar()) {
            this.h = (IVariable)head.s();
        } else if (head.p().isVar()) {
            this.h = (IVariable)head.p();
        } else if (head.o().isVar()) {
            this.h = (IVariable)head.o();
        } else {
            throw new AssertionError();
        }
        if (body[0].s() == this.h) {
            this.keyOrder = SPOKeyOrder.SPO;
        } else if (body[0].p() == this.h) {
            this.keyOrder = SPOKeyOrder.POS;
        } else if (body[0].o() == this.h) {
            this.keyOrder = SPOKeyOrder.OSP;
        } else {
            throw new AssertionError();
        }
        this.taskFactory = new DistinctTermScanRuleTaskFactory(this.h, this.keyOrder);
    }

    @Override
    public IRuleTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    protected static class DistinctTermScan
    implements IStepTask,
    Serializable {
        private static final long serialVersionUID = -7570511260700545025L;
        private final IJoinNexus joinNexus;
        private final IBuffer<ISolution[]> buffer;
        private final IRule rule;
        private final IVariable<IV> h;
        private final SPOKeyOrder keyOrder;

        public DistinctTermScan(IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> buffer, IVariable<IV> h, SPOKeyOrder keyOrder) {
            if (rule == null) {
                throw new IllegalArgumentException();
            }
            if (joinNexus == null) {
                throw new IllegalArgumentException();
            }
            if (buffer == null) {
                throw new IllegalArgumentException();
            }
            if (h == null) {
                throw new IllegalArgumentException();
            }
            if (keyOrder == null) {
                throw new IllegalArgumentException();
            }
            this.rule = rule;
            this.joinNexus = joinNexus;
            this.buffer = buffer;
            this.h = h;
            this.keyOrder = keyOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RuleStats call() {
            long computeStart = System.currentTimeMillis();
            SPORelation relation = (SPORelation)this.joinNexus.getTailRelationView(this.rule.getTail(0));
            RuleStats ruleStats = this.joinNexus.getRuleStatisticsFactory().newInstance(this.rule);
            ListBindingSet bindingSet = new ListBindingSet();
            IChunkedIterator<IV> itr = relation.distinctTermScan(this.keyOrder);
            try {
                while (itr.hasNext()) {
                    IV[] chunk = itr.nextChunk();
                    ruleStats.chunkCount[0] = ruleStats.chunkCount[0] + 1L;
                    ruleStats.elementCount[0] = ruleStats.elementCount[0] + (long)chunk.length;
                    IBuffer<ISolution> tmp = this.joinNexus.newUnsynchronizedBuffer(this.buffer, chunk.length);
                    for (IV iv : chunk) {
                        bindingSet.set(this.h, new Constant<IV>(iv));
                        if (!this.rule.isConsistent(bindingSet)) continue;
                        tmp.add(this.joinNexus.newSolution(this.rule, bindingSet));
                        ruleStats.solutionCount.incrementAndGet();
                    }
                    tmp.flush();
                }
            }
            finally {
                itr.close();
                ruleStats.elapsed += System.currentTimeMillis() - computeStart;
            }
            return ruleStats;
        }
    }

    private static class DistinctTermScanRuleTaskFactory
    implements IRuleTaskFactory {
        private static final long serialVersionUID = 3290328271137950004L;
        private final IVariable<IV> h;
        private final SPOKeyOrder keyOrder;

        public DistinctTermScanRuleTaskFactory(IVariable<IV> h, SPOKeyOrder keyOrder) {
            this.h = h;
            this.keyOrder = keyOrder;
        }

        @Override
        public IStepTask newTask(IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> buffer) {
            return new DistinctTermScan(rule, joinNexus, buffer, this.h, this.keyOrder);
        }
    }
}

