/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSailQuery;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.concurrent.TimeUnit;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.repository.sail.SailBooleanQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;

public class BigdataSailBooleanQuery
extends SailBooleanQuery
implements BigdataSailQuery {
    private final ASTContainer astContainer;

    @Override
    public ASTContainer getASTContainer() {
        return this.astContainer;
    }

    public String toString() {
        return this.astContainer.toString();
    }

    @Override
    public AbstractTripleStore getTripleStore() {
        return ((BigdataSailRepositoryConnection)this.getConnection()).getTripleStore();
    }

    public BigdataSailBooleanQuery(ASTContainer astContainer, BigdataSailRepositoryConnection con) {
        super(null, (SailRepositoryConnection)con);
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        this.astContainer = astContainer;
    }

    public boolean evaluate() throws QueryEvaluationException {
        return this.evaluate(null);
    }

    public boolean evaluate(BindingsClause bc) throws QueryEvaluationException {
        QueryRoot originalQuery = this.astContainer.getOriginalAST();
        if (bc != null) {
            originalQuery.setBindingsClause(bc);
        }
        if (this.getMaxQueryTime() > 0) {
            originalQuery.setTimeout(TimeUnit.SECONDS.toMillis(this.getMaxQueryTime()));
        }
        originalQuery.setIncludeInferred(this.getIncludeInferred());
        boolean queryResult = ASTEvalHelper.evaluateBooleanQuery(this.getTripleStore(), this.astContainer, (BindingSet)new QueryBindingSet(this.getBindings()), this.getDataset());
        return queryResult;
    }
}

