/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailBooleanQuery;
import com.bigdata.rdf.sail.BigdataSailGraphQuery;
import com.bigdata.rdf.sail.BigdataSailQuery;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sail.BigdataSailUpdate;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.store.AbstractTripleStore;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailQuery;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class BigdataSailRepositoryConnection
extends SailRepositoryConnection {
    private static final transient Logger log = Logger.getLogger(BigdataSailRepositoryConnection.class);

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{timestamp=" + TimestampUtility.toString(this.getTripleStore().getTimestamp()) + "}";
    }

    public BigdataSailRepositoryConnection(BigdataSailRepository repository, SailConnection sailConnection) {
        super((SailRepository)repository, sailConnection);
    }

    public BigdataSailRepository getRepository() {
        return (BigdataSailRepository)super.getRepository();
    }

    public BigdataSail.BigdataSailConnection getSailConnection() {
        return (BigdataSail.BigdataSailConnection)super.getSailConnection();
    }

    public BigdataValueFactory getValueFactory() {
        return (BigdataValueFactory)super.getValueFactory();
    }

    public boolean hasStatement(Resource s, URI p, Value o, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return super.hasStatement(s, p, o, includeInferred, contexts);
    }

    public BigdataSailGraphQuery prepareGraphQuery(QueryLanguage ql, String qs, String baseURI) throws MalformedQueryException {
        return (BigdataSailGraphQuery)this.prepareQuery(ql, qs, baseURI);
    }

    public BigdataSailTupleQuery prepareTupleQuery(QueryLanguage ql, String qs, String baseURI) throws MalformedQueryException {
        return (BigdataSailTupleQuery)this.prepareQuery(ql, qs, baseURI);
    }

    public BigdataSailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String qs, String baseURI) throws MalformedQueryException {
        return (BigdataSailBooleanQuery)this.prepareQuery(ql, qs, baseURI);
    }

    public SailQuery prepareQuery(QueryLanguage ql, String qs, String baseURI) throws MalformedQueryException {
        if (ql == QueryLanguage.SPARQL) {
            return (SailQuery)this.prepareNativeSPARQLQuery(ql, qs, baseURI);
        }
        throw new MalformedQueryException("Unsupported language: " + ql);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql == QueryLanguage.SPARQL) {
            return this.prepareNativeSPARQLUpdate(ql, update, baseURI);
        }
        throw new MalformedQueryException("Unsupported language: " + ql);
    }

    public BigdataSailQuery prepareNativeSPARQLQuery(QueryLanguage ql, String queryStr, String baseURI) throws MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(ql.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)queryStr);
        }
        this.getSailConnection().flushStatementBuffers(true, true);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(queryStr, baseURI);
        QueryType queryType = astContainer.getOriginalAST().getQueryType();
        switch (queryType) {
            case SELECT: {
                return new BigdataSailTupleQuery(astContainer, this);
            }
            case DESCRIBE: 
            case CONSTRUCT: {
                return new BigdataSailGraphQuery(astContainer, this);
            }
            case ASK: {
                return new BigdataSailBooleanQuery(astContainer, this);
            }
        }
        throw new RuntimeException("Unknown query type: " + (Object)((Object)queryType));
    }

    public BigdataSailUpdate prepareNativeSPARQLUpdate(QueryLanguage ql, String updateStr, String baseURI) throws MalformedQueryException {
        if (this.getTripleStore().isReadOnly()) {
            throw new UnsupportedOperationException("Read only");
        }
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(ql.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)updateStr);
        }
        this.getSailConnection().flushStatementBuffers(true, true);
        ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseUpdate2(updateStr, baseURI);
        return new BigdataSailUpdate(astContainer, this);
    }

    public final boolean isReadOnly() {
        return this.getSailConnection().isReadOnly();
    }

    public final boolean isUnisolated() {
        return this.getSailConnection().isUnisolated();
    }

    public long commit2() throws RepositoryException {
        if (this.isAutoCommit() && !this.getSailConnection().getAllowAutoCommit()) {
            throw new RepositoryException("please set autoCommit to false");
        }
        try {
            return this.getSailConnection().commit2();
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void commit() throws RepositoryException {
        this.commit2();
    }

    public void flush() throws RepositoryException {
        try {
            this.getSailConnection().flush();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public AbstractTripleStore getTripleStore() {
        return this.getSailConnection().database;
    }

    public void computeClosure() throws RepositoryException {
        try {
            this.getSailConnection().computeClosure();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void removeAllEntailments() throws SailException, RepositoryException {
        try {
            this.getSailConnection().removeAllEntailments();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void addChangeLog(IChangeLog log) {
        this.getSailConnection().addChangeLog(log);
    }

    public void removeChangeLog(IChangeLog log) {
        this.getSailConnection().removeChangeLog(log);
    }
}

