/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.ValueExprBuilder;
import com.bigdata.rdf.sail.sparql.ast.ASTBind;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNodePropertyList;
import com.bigdata.rdf.sail.sparql.ast.ASTCollection;
import com.bigdata.rdf.sail.sparql.ast.ASTObjectList;
import com.bigdata.rdf.sail.sparql.ast.ASTPathAlternative;
import com.bigdata.rdf.sail.sparql.ast.ASTPathElt;
import com.bigdata.rdf.sail.sparql.ast.ASTPathMod;
import com.bigdata.rdf.sail.sparql.ast.ASTPathOneInPropertySet;
import com.bigdata.rdf.sail.sparql.ast.ASTPathSequence;
import com.bigdata.rdf.sail.sparql.ast.ASTPropertyList;
import com.bigdata.rdf.sail.sparql.ast.ASTPropertyListPath;
import com.bigdata.rdf.sail.sparql.ast.ASTTRefPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTVar;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.optimizers.ASTPropertyPathOptimizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class TriplePatternExprBuilder
extends ValueExprBuilder {
    private static final transient Logger log = Logger.getLogger(TriplePatternExprBuilder.class);

    public TriplePatternExprBuilder(BigdataASTContext context) {
        super(context);
    }

    @Override
    public final Object visit(ASTPropertyList propListNode, Object data) throws VisitorException {
        TermNode subject = (TermNode)data;
        TermNode predicate = (TermNode)propListNode.getVerb().jjtAccept((SyntaxTreeBuilderVisitor)this, null);
        List objectList = (List)propListNode.getObjectList().jjtAccept((SyntaxTreeBuilderVisitor)this, null);
        for (TermNode object : objectList) {
            this.graphPattern.addSP(subject, predicate, object);
        }
        ASTPropertyList nextPropList = propListNode.getNextPropertyList();
        if (nextPropList != null) {
            nextPropList.jjtAccept((SyntaxTreeBuilderVisitor)this, (Object)subject);
        }
        return null;
    }

    @Override
    public final Object visit(ASTPropertyListPath propListNode, Object data) throws VisitorException {
        ASTPropertyListPath nextPropList;
        TermNode subject = (TermNode)data;
        BOp verb = (BOp)propListNode.getVerb().jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        List objectList = (List)propListNode.getObjectList().jjtAccept((SyntaxTreeBuilderVisitor)this, null);
        if (verb instanceof TermNode) {
            TermNode predicate = (TermNode)verb;
            for (TermNode object : objectList) {
                this.graphPattern.addSP(subject, predicate, object);
            }
        } else {
            PathNode.PathAlternative pathAlt = (PathNode.PathAlternative)verb;
            if (ASTPropertyPathOptimizer.isSimpleIRI(pathAlt)) {
                ConstantNode predicate = ASTPropertyPathOptimizer.getSimpleIRI(pathAlt);
                for (TermNode object : objectList) {
                    this.graphPattern.addSP(subject, predicate, object);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)BOpUtility.toString(pathAlt));
                }
                PathNode path = new PathNode(pathAlt);
                for (TermNode object : objectList) {
                    this.graphPattern.addPP(subject, path, object);
                }
            }
        }
        if ((nextPropList = propListNode.getNextPropertyList()) != null) {
            nextPropList.jjtAccept((SyntaxTreeBuilderVisitor)this, (Object)subject);
        }
        return null;
    }

    @Override
    public PathNode.PathAlternative visit(ASTPathAlternative pathAltNode, Object data) throws VisitorException {
        int numChildren = pathAltNode.jjtGetNumChildren();
        PathNode.PathSequence[] args = new PathNode.PathSequence[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            args[i] = (PathNode.PathSequence)pathAltNode.jjtGetChild(i).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        }
        return new PathNode.PathAlternative(args);
    }

    @Override
    public PathNode.PathSequence visit(ASTPathSequence pathSeqNode, Object data) throws VisitorException {
        int numChildren = pathSeqNode.jjtGetNumChildren();
        PathNode.PathElt[] args = new PathNode.PathElt[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            args[i] = (PathNode.PathElt)pathSeqNode.jjtGetChild(i).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        }
        return new PathNode.PathSequence(args);
    }

    @Override
    public Object visit(ASTPathElt pathEltNode, Object data) throws VisitorException {
        BOp arg;
        if (pathEltNode.isNegatedPropertySet()) {
            int numChildren = pathEltNode.jjtGetNumChildren();
            PathNode.PathOneInPropertySet[] args = new PathNode.PathOneInPropertySet[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                args[i] = (PathNode.PathOneInPropertySet)pathEltNode.jjtGetChild(i).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
            }
            arg = new PathNode.PathNegatedPropertySet(args);
        } else {
            arg = (BOp)pathEltNode.jjtGetChild(0).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        }
        boolean inverse = pathEltNode.isInverse();
        PathNode.PathMod mod = this.toPathMod(pathEltNode.getPathMod());
        return new PathNode.PathElt(arg, inverse, mod);
    }

    private PathNode.PathMod toPathMod(ASTPathMod pathModNode) {
        if (pathModNode == null) {
            return null;
        }
        long lower = pathModNode.getLowerBound();
        long upper = pathModNode.getUpperBound();
        if (upper == 1L) {
            return PathNode.PathMod.ZERO_OR_ONE;
        }
        if (lower == 1L) {
            return PathNode.PathMod.ONE_OR_MORE;
        }
        return PathNode.PathMod.ZERO_OR_MORE;
    }

    @Override
    public Object visit(ASTPathOneInPropertySet node, Object data) throws VisitorException {
        ConstantNode arg = (ConstantNode)node.jjtGetChild(0).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        boolean inverse = node.isInverse();
        return new PathNode.PathOneInPropertySet(arg, inverse);
    }

    @Override
    public final List<TermNode> visit(ASTObjectList node, Object data) throws VisitorException {
        int childCount = node.jjtGetNumChildren();
        ArrayList<TermNode> result = new ArrayList<TermNode>(childCount);
        for (int i = 0; i < childCount; ++i) {
            result.add((TermNode)node.jjtGetChild(i).jjtAccept((SyntaxTreeBuilderVisitor)this, null));
        }
        return result;
    }

    @Override
    public final VarNode visit(ASTBlankNodePropertyList node, Object data) throws VisitorException {
        VarNode bnodeVar = this.context.createAnonVar(node.getVarName());
        super.visit(node, (Object)bnodeVar);
        return bnodeVar;
    }

    @Override
    public VarNode visit(ASTCollection node, Object data) throws VisitorException {
        VarNode rootListVar;
        String listVarName = node.getVarName();
        TermNode listVar = rootListVar = this.context.createAnonVar(listVarName);
        int childCount = node.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            TermNode childValue = (TermNode)node.jjtGetChild(i).jjtAccept((SyntaxTreeBuilderVisitor)this, null);
            this.graphPattern.addSP(listVar, this.context.createConstVar((Value)RDF.FIRST), childValue);
            TermNode nextListVar = i == childCount - 1 ? this.context.createConstVar((Value)RDF.NIL) : this.context.createAnonVar(listVarName + "-" + (i + 1));
            this.graphPattern.addSP(listVar, this.context.createConstVar((Value)RDF.REST), nextListVar);
            listVar = nextListVar;
        }
        return rootListVar;
    }

    @Override
    public VarNode visit(ASTTRefPattern node, Object data) throws VisitorException {
        VarNode sidVar;
        BigdataValue v;
        TermNode s = (TermNode)node.jjtGetChild(0).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        TermNode p = (TermNode)node.jjtGetChild(1).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        TermNode o = (TermNode)node.jjtGetChild(2).jjtAccept((SyntaxTreeBuilderVisitor)this, data);
        if (s instanceof ConstantNode) {
            v = ((ConstantNode)s).getValue();
            if (v instanceof Literal) {
                throw new VisitorException("Subject in triple reference pattern may not be literal.");
            }
        } else if (((VarNode)s).isAnonymous()) {
            throw new VisitorException("Subject in triple reference pattern may not be blank node.");
        }
        if (p instanceof ConstantNode && !((v = ((ConstantNode)p).getValue()) instanceof URI)) {
            throw new VisitorException("Predicate in triple reference pattern must be IRI.");
        }
        if (o instanceof ConstantNode ? (v = ((ConstantNode)o).getValue()) instanceof BNode : ((VarNode)o).isAnonymous()) {
            throw new VisitorException("Object in triple reference pattern may not be blank node.");
        }
        StatementPatternNode sp = new StatementPatternNode(s, p, o, this.graphPattern.getContext(), this.graphPattern.getStatementPatternScope());
        Node parent = node.jjtGetParent();
        if (parent instanceof ASTBind) {
            ASTBind bind = (ASTBind)parent;
            Node aliasNode = bind.jjtGetChild(1);
            String alias = ((ASTVar)aliasNode).getName();
            sidVar = new VarNode(alias);
        } else {
            sidVar = this.context.createSidVar();
        }
        sp.setSid(sidVar);
        this.graphPattern.addSP(sp);
        return sidVar;
    }
}

