/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.ITx;
import com.bigdata.journal.Journal;
import com.bigdata.journal.Tx;
import com.bigdata.journal.ValidationError;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ITxState;
import com.bigdata.util.InnerCause;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class TxServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(TxServlet.class);
    static final transient String ATTR_PREPARE = "PREPARE";
    static final transient String ATTR_COMMIT = "COMMIT";
    static final transient String ATTR_ABORT = "ABORT";
    static final transient String ATTR_STATUS = "STATUS";
    static final transient String ATTR_TIMESTAMP = "timestamp";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!TxServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        if (req.getRequestURI().endsWith("/tx")) {
            this.doCreateTx(req, resp);
            return;
        }
        if (req.getParameter(ATTR_PREPARE) != null) {
            this.doPrepareTx(req, resp);
        } else if (req.getParameter(ATTR_ABORT) != null) {
            this.doAbortTx(req, resp);
        } else if (req.getParameter(ATTR_COMMIT) != null) {
            this.doCommitTx(req, resp);
        } else if (req.getParameter(ATTR_STATUS) != null) {
            this.doStatusTx(req, resp);
        } else {
            TxServlet.buildAndCommitResponse(resp, 400, "text/html", "Unknown transaction management request", new NV[0]);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!TxServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        if (req.getRequestURI().endsWith("/tx")) {
            this.doListTx(req, resp);
            return;
        }
        if (req.getParameter(ATTR_STATUS) != null) {
            this.doStatusTx(req, resp);
        } else {
            TxServlet.buildAndCommitResponse(resp, 400, "text/html", "Unknown transaction management request", new NV[0]);
        }
    }

    private void doCreateTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long beginNanos = System.nanoTime();
        long timestamp = this.getTimestamp(req);
        if (timestamp == 0L) {
            if (!TxServlet.isWritable(this.getServletContext(), req, resp)) {
                return;
            }
            if (this.getIndexManager() instanceof IBigdataFederation) {
                TxServlet.buildAndCommitResponse(resp, 400, "text/html", "Scale-out does not support distributed read/write transactions", new NV[0]);
            }
        } else if (timestamp != -1L && timestamp <= 0L) {
            TxServlet.buildAndCommitResponse(resp, 400, "text/html", "Illegal value: timestamp=" + timestamp, new NV[0]);
            return;
        }
        try {
            long txId = this.getBigdataRDFContext().newTx(timestamp);
            String txURL = req.getRequestURL().append('/').append((Object)txId).toString();
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
            StringWriter w = new StringWriter();
            XMLBuilder t = new XMLBuilder(w);
            XMLBuilder.Node root = t.root("response");
            root.attr("elapsed", elapsedMillis);
            TxServlet.addTx(root, txId, this.getReadsOnCommitTimeOrNull(txId));
            root.close();
            TxServlet.buildAndCommitResponse(resp, 201, "application/xml", w.toString(), new NV("Location", txURL));
        }
        catch (Throwable t) {
            TxServlet.launderThrowable(t, resp, "CREATE-TX");
        }
    }

    private void doAbortTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long beginNanos = System.nanoTime();
        AtomicLong txId = new AtomicLong();
        if (!this.getTxId(req, resp, txId)) {
            return;
        }
        try {
            if (this.getIndexManager() instanceof IBigdataFederation) {
                ((IBigdataFederation)this.getIndexManager()).getTransactionService().abort(txId.get());
            } else {
                ITx tx = ((Journal)this.getIndexManager()).getTransactionManager().getTx(txId.get());
                if (tx == null) {
                    TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "ABORT-TX: Transaction not found: txId=" + txId, new NV[0]);
                    return;
                }
                if (!tx.isEmptyWriteSet() && !TxServlet.isWritable(this.getServletContext(), req, resp)) {
                    return;
                }
                ((Journal)this.getIndexManager()).abort(txId.get());
            }
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
            StringWriter w = new StringWriter();
            XMLBuilder t = new XMLBuilder(w);
            XMLBuilder.Node root = t.root("response");
            root.attr("elapsed", elapsedMillis);
            TxServlet.addTx(root, txId.get(), this.getReadsOnCommitTimeOrNull(txId.get()));
            root.close();
            TxServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV[0]);
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, IllegalStateException.class)) {
                TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "ABORT-TX: Transaction not found: txId=" + txId, new NV[0]);
                return;
            }
            TxServlet.launderThrowable(t, resp, "ABORT-TX:: txId=" + txId);
        }
    }

    private void doCommitTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long beginNanos = System.nanoTime();
        AtomicLong txId = new AtomicLong();
        if (!this.getTxId(req, resp, txId)) {
            return;
        }
        try {
            if (this.getIndexManager() instanceof IBigdataFederation) {
                ((IBigdataFederation)this.getIndexManager()).getTransactionService().commit(txId.get());
            } else {
                ITx tx = ((Journal)this.getIndexManager()).getTransactionManager().getTx(txId.get());
                if (tx == null) {
                    TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "COMMIT-TX: Transaction not found: txId=" + txId, new NV[0]);
                    return;
                }
                if (!tx.isEmptyWriteSet() && !TxServlet.isWritable(this.getServletContext(), req, resp)) {
                    return;
                }
                ((Journal)this.getIndexManager()).commit(txId.get());
            }
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
            StringWriter w = new StringWriter();
            XMLBuilder t = new XMLBuilder(w);
            XMLBuilder.Node root = t.root("response");
            root.attr("elapsed", elapsedMillis);
            TxServlet.addTx(root, txId.get(), this.getReadsOnCommitTimeOrNull(txId.get()));
            root.close();
            TxServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV[0]);
        }
        catch (Throwable e) {
            if (InnerCause.isInnerCause((Throwable)e, ValidationError.class)) {
                long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
                StringWriter w = new StringWriter();
                XMLBuilder t = new XMLBuilder(w);
                XMLBuilder.Node root = t.root("response");
                root.attr("elapsed", elapsedMillis);
                TxServlet.addTx(root, txId.get(), this.getReadsOnCommitTimeOrNull(txId.get()));
                root.close();
                TxServlet.buildAndCommitResponse(resp, 409, "application/xml", w.toString(), new NV[0]);
                return;
            }
            if (InnerCause.isInnerCause((Throwable)e, IllegalStateException.class)) {
                TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "COMMIT-TX: Transaction not found: txId=" + txId, new NV[0]);
                return;
            }
            TxServlet.launderThrowable(e, resp, "COMMIT-TX:: txId=" + txId);
        }
    }

    private void doPrepareTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long beginNanos = System.nanoTime();
        AtomicLong txId = new AtomicLong();
        if (!this.getTxId(req, resp, txId)) {
            return;
        }
        try {
            boolean ok;
            if (this.getIndexManager() instanceof IBigdataFederation) {
                ok = true;
            } else {
                ITx tx = ((Journal)this.getIndexManager()).getTransactionManager().getTx(txId.get());
                if (tx == null) {
                    TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "PREPARE-TX: Transaction not found: txId=" + txId, new NV[0]);
                    return;
                }
                if (!tx.isEmptyWriteSet() && !TxServlet.isWritable(this.getServletContext(), req, resp)) {
                    return;
                }
                ok = ((Journal)this.getIndexManager()).prepare(txId.get());
            }
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
            StringWriter w = new StringWriter();
            XMLBuilder t = new XMLBuilder(w);
            XMLBuilder.Node root = t.root("response");
            root.attr("elapsed", elapsedMillis);
            TxServlet.addTx(root, txId.get(), this.getReadsOnCommitTimeOrNull(txId.get()));
            root.close();
            int statusCode = ok ? 200 : 409;
            TxServlet.buildAndCommitResponse(resp, statusCode, "application/xml", w.toString(), new NV[0]);
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, IllegalStateException.class)) {
                TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "PREPARE-TX: Transaction not found: txId=" + txId, new NV[0]);
                return;
            }
            TxServlet.launderThrowable(t, resp, "PREPARE-TX:: txId=" + txId);
        }
    }

    private void doStatusTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long beginNanos = System.nanoTime();
        AtomicLong txId = new AtomicLong();
        if (!this.getTxId(req, resp, txId)) {
            return;
        }
        try {
            if (this.getIndexManager() instanceof IBigdataFederation) {
                TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "Scale-out does not support STATUS-TX", new NV[0]);
                return;
            }
            ITx tx = ((Journal)this.getIndexManager()).getTransactionManager().getTx(txId.get());
            if (tx == null) {
                TxServlet.buildAndCommitResponse(resp, 410, "text/plain", "STATUS-TX: Transaction not found: txId=" + txId, new NV[0]);
                return;
            }
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginNanos);
            StringWriter w = new StringWriter();
            XMLBuilder t = new XMLBuilder(w);
            XMLBuilder.Node root = t.root("response");
            root.attr("elapsed", elapsedMillis);
            TxServlet.addTx(root, txId.get(), this.getReadsOnCommitTimeOrNull(txId.get()));
            root.close();
            TxServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV("Cache-Control", "no-cache"));
            return;
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, IllegalStateException.class)) {
                TxServlet.buildAndCommitResponse(resp, 404, "text/plain", "STATUS-TX: Transaction not found: txId=" + txId, new NV[0]);
                return;
            }
            TxServlet.launderThrowable(t, resp, "PREPARE-TX:: txId=" + txId);
            return;
        }
    }

    private void doListTx(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ITxState[] a = this.getIndexManager() instanceof IBigdataFederation ? new ITxState[]{} : ((Journal)this.getIndexManager()).getTransactionManager().getActiveTx();
        StringWriter w = new StringWriter();
        XMLBuilder t = new XMLBuilder(w);
        XMLBuilder.Node root = t.root("response");
        for (ITxState tx : a) {
            TxServlet.addTx(root, tx);
        }
        root.close();
        TxServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV("Cache-Control", "no-cache"));
    }

    private final boolean getTxId(HttpServletRequest req, HttpServletResponse resp, AtomicLong ref) throws IOException {
        String pathInfo = req.getPathInfo();
        assert (pathInfo != null);
        if (pathInfo.length() < 2) {
            TxServlet.buildAndCommitResponse(resp, 400, "text/html", "No transaction identifier in path: pathInfo=" + pathInfo, new NV[0]);
            return false;
        }
        String s = pathInfo.substring(1);
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i)) || s.charAt(i) == '-') continue;
            TxServlet.buildAndCommitResponse(resp, 400, "text/html", "Transaction identifier is not numeric: pathInfo=" + pathInfo, new NV[0]);
            return false;
        }
        long txId = Long.valueOf(s);
        ref.set(txId);
        return true;
    }

    private Long getReadsOnCommitTimeOrNull(long txId) {
        if (this.getIndexManager() instanceof IBigdataFederation) {
            return null;
        }
        Tx tx = ((Journal)this.getIndexManager()).getLocalTransactionManager().getTx(txId);
        if (tx == null) {
            return null;
        }
        return tx.getReadsOnCommitTime();
    }

    private static void addTx(XMLBuilder.Node parent, ITxState tx) throws IOException {
        TxServlet.addTx(parent, tx.getStartTimestamp(), tx.getReadsOnCommitTime());
    }

    private static void addTx(XMLBuilder.Node parent, long txId, Long readsOnCommitTime) throws IOException {
        if (txId == 0L) {
            throw new IllegalArgumentException();
        }
        if (txId == -1L) {
            throw new IllegalArgumentException();
        }
        boolean readOnly = txId > 0L;
        XMLBuilder.Node t = parent.node("tx");
        t.attr("txId", txId);
        if (readsOnCommitTime != null) {
            t.attr("readsOnCommitTime", readsOnCommitTime);
        }
        t.attr("readOnly", readOnly);
        t.close();
    }
}

