/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphUpdate;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateType;
import java.util.Map;

public class LoadGraph
extends GraphUpdate {
    private static final long serialVersionUID = 1L;

    public LoadGraph() {
        super(UpdateType.Load);
    }

    public LoadGraph(LoadGraph op) {
        super(op);
    }

    public LoadGraph(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    @Override
    public ConstantNode getSourceGraph() {
        return (ConstantNode)this.getProperty("source");
    }

    @Override
    public void setSourceGraph(ConstantNode sourceGraph) {
        if (sourceGraph == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("source", sourceGraph);
    }

    @Override
    public ConstantNode getTargetGraph() {
        return (ConstantNode)this.getProperty("target");
    }

    @Override
    public void setTargetGraph(ConstantNode targetGraph) {
        if (targetGraph == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("target", targetGraph);
    }

    @Override
    public boolean isSilent() {
        return this.getProperty("silent", false);
    }

    @Override
    public void setSilent(boolean silent) {
        this.setProperty("silent", silent);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(LoadGraph.indent(indent));
        sb.append((Object)this.getUpdateType());
        boolean silent = this.isSilent();
        ConstantNode sourceGraph = this.getSourceGraph();
        ConstantNode targetGraph = this.getTargetGraph();
        if (silent) {
            sb.append(" SILENT");
        }
        if (this.getProperty("verifyData") != null) {
            sb.append(" verifyData=" + this.getProperty("verifyData"));
        }
        if (this.getProperty("preserveBlankNodeIDs") != null) {
            sb.append(" preserveBlankNodeIDs=" + this.getProperty("preserveBlankNodeIDs"));
        }
        if (this.getProperty("stopAtFirstError") != null) {
            sb.append(" stopAtFirstError=" + this.getProperty("stopAtFirstError"));
        }
        if (this.getProperty("dataTypeHandling") != null) {
            sb.append(" dataTypeHandling=" + this.getProperty("dataTypeHandling"));
        }
        if (sourceGraph != null) {
            sb.append("\n");
            sb.append(LoadGraph.indent(indent + 1));
            sb.append("source=" + sourceGraph);
        }
        if (targetGraph != null) {
            sb.append("\n");
            sb.append(LoadGraph.indent(indent + 1));
            sb.append("target=" + targetGraph);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static interface Annotations
    extends Update.Annotations {
        public static final String VERIFY_DATA = "verifyData";
        public static final String PRESERVE_BLANK_NODE_IDS = "preserveBlankNodeIDs";
        public static final String STOP_AT_FIRST_ERROR = "stopAtFirstError";
        public static final String DATA_TYPE_HANDLING = "dataTypeHandling";
    }
}

