/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.rdf.join.ChunkedMaterializationIterator;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.Bigdata2Sesame2BindingSetIterator;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.RunningQueryCloseableIterator;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.DescribeModeEnum;
import com.bigdata.rdf.sparql.ast.IDataSetNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.cache.DescribeBindingsCollector;
import com.bigdata.rdf.sparql.ast.cache.DescribeCacheUpdater;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdate;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdateContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.sparql.ast.eval.CBD;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataBindingSetResolverator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.Dechunkerator;
import cutthecrap.utils.striterators.ICloseableIterator;
import info.aduna.iteration.CloseableIteration;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.query.impl.TupleQueryResultImpl;

public class ASTEvalHelper {
    private static final Logger log = Logger.getLogger(ASTEvalHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean evaluateBooleanQuery(AbstractTripleStore store, ASTContainer astContainer, BindingSet globallyScopedBS, Dataset dataset) throws QueryEvaluationException {
        ASTDeferredIVResolution.DeferredResolutionResult resolved;
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        try {
            resolved = ASTDeferredIVResolution.resolveQuery(store, astContainer, globallyScopedBS, dataset, context);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        if (resolved.dataset != null) {
            astContainer.getOriginalAST().setDataset(new DatasetNode(resolved.dataset, false));
        }
        astContainer.clearOptimizedAST();
        IBindingSet[] globallyScopedBSAsList = ASTEvalHelper.toBindingSet(resolved.bindingSet);
        AST2BOpUtility.convert(context, globallyScopedBSAsList);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        try (CloseableIteration<BindingSet, QueryEvaluationException> itr = null;){
            itr = ASTEvalHelper.evaluateQuery(astContainer, context, materializeProjectionInQuery, new IVariable[0]);
            boolean bl = itr.hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TupleQueryResult evaluateTupleQuery(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet globallyScopedBS, Dataset dataset) throws QueryEvaluationException {
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        QueryRoot optimizedQuery = ASTEvalHelper.optimizeQuery(astContainer, context, globallyScopedBS, dataset);
        IVariable[] projected = astContainer.getOptimizedAST().getProjection().getProjectionVars();
        LinkedList<String> projectedSet = new LinkedList<String>();
        for (IVariable var : projected) {
            projectedSet.add(var.getName());
        }
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        CloseableIteration<BindingSet, QueryEvaluationException> itr = ASTEvalHelper.evaluateQuery(astContainer, context, materializeProjectionInQuery, projected);
        TupleQueryResultImpl r = null;
        try {
            TupleQueryResultImpl tupleQueryResultImpl = r = new TupleQueryResultImpl(projectedSet, itr);
            return tupleQueryResultImpl;
        }
        finally {
            if (r == null) {
                itr.close();
            }
        }
    }

    public static ICloseableIterator<IBindingSet[]> evaluateTupleQuery2(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet globallyScopedBS, boolean materialize) throws QueryEvaluationException {
        LinkedList<String> projectedSet;
        boolean materializeProjectionInQuery;
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        astContainer.clearOptimizedAST();
        IBindingSet[] globallyScopedBSAsList = ASTEvalHelper.toBindingSet((BindingSet)globallyScopedBS);
        AST2BOpUtility.convert(context, globallyScopedBSAsList);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        boolean bl = materializeProjectionInQuery = materialize && context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        if (materialize) {
            IVariable[] projected = astContainer.getOptimizedAST().getProjection().getProjectionVars();
            projectedSet = new LinkedList<String>();
            for (IVariable var : projected) {
                projectedSet.add(var.getName());
            }
        } else {
            projectedSet = null;
        }
        ASTEvalHelper.doSparqlLogging(context);
        PipelineOp queryPlan = astContainer.getQueryPlan();
        AbstractRunningQuery runningQuery = null;
        try {
            ChunkedMaterializationIterator it2;
            runningQuery = context.queryEngine.eval((BOp)queryPlan, globallyScopedBSAsList);
            ChunkedMaterializationIterator it1 = runningQuery.iterator();
            if (materialize && !materializeProjectionInQuery && !projectedSet.isEmpty()) {
                IVariable[] vars = projectedSet.toArray(new IVariable[projectedSet.size()]);
                it2 = new ChunkedMaterializationIterator(vars, context.db.getLexiconRelation(), false, it1);
            } else {
                it2 = it1;
            }
            return it2;
        }
        catch (Throwable t) {
            if (runningQuery != null) {
                runningQuery.cancel(true);
            }
            throw new QueryEvaluationException(t);
        }
    }

    public static QueryRoot optimizeQuery(ASTContainer astContainer, AST2BOpContext context, QueryBindingSet globallyScopedBS, Dataset dataset) throws QueryEvaluationException {
        ASTDeferredIVResolution.DeferredResolutionResult resolved;
        AbstractTripleStore store = context.getAbstractTripleStore();
        try {
            resolved = ASTDeferredIVResolution.resolveQuery(store, astContainer, (BindingSet)globallyScopedBS, dataset, context);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        if (resolved.dataset != null) {
            astContainer.getOriginalAST().setDataset(new DatasetNode(resolved.dataset, false));
        }
        astContainer.clearOptimizedAST();
        IBindingSet[] globallyScopedBSAsList = ASTEvalHelper.toBindingSet(resolved.bindingSet);
        AST2BOpUtility.convert(context, globallyScopedBSAsList);
        QueryRoot optimizedQuery = astContainer.getOptimizedAST();
        return optimizedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphQueryResult evaluateGraphQuery(AbstractTripleStore store, ASTContainer astContainer, QueryBindingSet globallyScopedBS, Dataset dataset) throws QueryEvaluationException {
        Set<IVariable<?>> describeVars;
        IDescribeCache describeCache;
        LinkedHashMap<String, BigdataBNode> bnodes;
        AST2BOpContext context = new AST2BOpContext(astContainer, store);
        boolean isDescribe = astContainer.getOriginalAST().getQueryType() == QueryType.DESCRIBE;
        LinkedHashMap<String, BigdataBNode> linkedHashMap = bnodes = isDescribe ? new LinkedHashMap<String, BigdataBNode>() : null;
        if (isDescribe && context.describeCache != null) {
            describeCache = context.getDescribeCache();
            describeVars = astContainer.getOriginalAST().getProjectedVars(new LinkedHashSet());
        } else {
            describeCache = null;
            describeVars = null;
        }
        QueryRoot optimizedQuery = ASTEvalHelper.optimizeQuery(astContainer, context, globallyScopedBS, dataset);
        boolean materializeProjectionInQuery = context.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        DescribeModeEnum describeMode = context.getDescribeMode(optimizedQuery.getProjection());
        int describeIterationLimit = context.getDescribeIterationLimit(optimizedQuery.getProjection());
        int describeStatementlimit = context.getDescribeStatementLimit(optimizedQuery.getProjection());
        GraphQueryResultImpl result = null;
        DescribeBindingsCollector solutions = ASTEvalHelper.evaluateQuery(astContainer, context, materializeProjectionInQuery, optimizedQuery.getProjection().getProjectionVars());
        try {
            CloseableIteration<BigdataStatement, QueryEvaluationException> src2;
            Set<BigdataValue> describedResources;
            block14: {
                CloseableIteration<BigdataStatement, QueryEvaluationException> src;
                block13: {
                    DescribeBindingsCollector solutions2;
                    if (describeCache != null) {
                        describedResources = Collections.newSetFromMap(new ConcurrentHashMap());
                        solutions2 = new DescribeBindingsCollector(describeVars, describedResources, solutions);
                    } else {
                        solutions2 = solutions;
                        describedResources = null;
                    }
                    src = new CloseableIteration<BigdataStatement, QueryEvaluationException>(context, store, optimizedQuery.getConstruct(), optimizedQuery.getWhereClause(), bnodes, (CloseableIteration<BindingSet, QueryEvaluationException>)solutions2);
                    if (!isDescribe) break block13;
                    switch (describeMode) {
                        case SymmetricOneStep: 
                        case ForwardOneStep: {
                            src2 = src;
                            break block14;
                        }
                        case CBD: 
                        case SCBD: {
                            src2 = new CBD(store, describeMode, describeIterationLimit, describeStatementlimit, bnodes).computeClosure(src);
                            break block14;
                        }
                        default: {
                            throw new UnsupportedOperationException("describeMode=" + (Object)((Object)describeMode));
                        }
                    }
                }
                src2 = src;
            }
            Object src3 = describeCache != null ? new DescribeCacheUpdater(describeCache, describedResources, src2) : src2;
            result = new GraphQueryResultImpl(optimizedQuery.getPrefixDecls(), (CloseableIteration)src3);
        }
        finally {
            if (result == null) {
                solutions.close();
            }
        }
        return result;
    }

    static CloseableIteration<BindingSet, QueryEvaluationException> evaluateQuery(ASTContainer astContainer, AST2BOpContext ctx, boolean materializeProjectionInQuery, IVariable<?>[] required) throws QueryEvaluationException {
        ASTEvalHelper.doSparqlLogging(ctx);
        PipelineOp queryPlan = astContainer.getQueryPlan();
        Future runningQuery = null;
        try {
            Map<Object, Object> queryAttributes = ctx.getQueryAttributes();
            runningQuery = ctx.queryEngine.eval(queryPlan, astContainer.getOptimizedASTBindingSets(), queryAttributes);
            runningQuery.setStaticAnalysisStats(ctx.getStaticAnalysisStats());
            return ASTEvalHelper.iterator((IRunningQuery)runningQuery, ctx.db, materializeProjectionInQuery, required);
        }
        catch (Throwable t) {
            if (runningQuery != null) {
                runningQuery.cancel(true);
            }
            throw new QueryEvaluationException(t);
        }
    }

    private static IBindingSet[] toBindingSet(BindingSet src) {
        if (src == null || src.size() == 0) {
            return new IBindingSet[]{new ListBindingSet()};
        }
        ListBindingSet bindingSet = new ListBindingSet();
        for (Binding binding : src) {
            Var var = Var.var(binding.getName());
            IV iv = ((BigdataValue)binding.getValue()).getIV();
            Constant<IV> val = new Constant<IV>(iv);
            bindingSet.set(var, val);
        }
        return new IBindingSet[]{bindingSet};
    }

    private static CloseableIteration<BindingSet, QueryEvaluationException> iterator(IRunningQuery runningQuery, AbstractTripleStore db, boolean materializeProjectionInQuery, IVariable<?>[] required) {
        Bigdata2Sesame2BindingSetIterator it3;
        ICloseableIterator<IBindingSet> it1 = ASTEvalHelper.iterator(runningQuery);
        BOp query = runningQuery.getQuery();
        int chunkCapacity = (Integer)query.getProperty(PipelineOp.Annotations.CHUNK_CAPACITY, (Object)100);
        ChunkedWrappedIterator<IBindingSet> it2 = new ChunkedWrappedIterator<IBindingSet>((Iterator<IBindingSet>)it1, chunkCapacity, IBindingSet.class);
        if (materializeProjectionInQuery) {
            it3 = new Bigdata2Sesame2BindingSetIterator(it2);
        } else {
            int chunkOfChunksCapacity = (Integer)query.getProperty(PipelineOp.Annotations.CHUNK_OF_CHUNKS_CAPACITY, (Object)5);
            long chunkTimeout = (Long)query.getProperty(PipelineOp.Annotations.CHUNK_TIMEOUT, (Object)10L);
            int termsChunkSize = chunkCapacity;
            int blobsChunkSize = chunkCapacity;
            it3 = new Bigdata2Sesame2BindingSetIterator(new BigdataBindingSetResolverator(db, it2, runningQuery.getQueryId(), required, chunkCapacity, chunkOfChunksCapacity, chunkTimeout, termsChunkSize, blobsChunkSize).start(db.getExecutorService()));
        }
        return it3;
    }

    private static ICloseableIterator<IBindingSet> iterator(IRunningQuery runningQuery) {
        ICloseableIterator<IBindingSet[]> it1 = runningQuery.iterator();
        Dechunkerator it2 = new Dechunkerator((Iterator<E[]>)it1);
        RunningQueryCloseableIterator<IBindingSet> it3 = new RunningQueryCloseableIterator<IBindingSet>(runningQuery, it2);
        return it3;
    }

    public static long executeUpdate(BigdataSailRepositoryConnection conn, ASTContainer astContainer, Dataset dataset, boolean includeInferred, QueryBindingSet bs) throws UpdateExecutionException {
        ASTDeferredIVResolution.DeferredResolutionResult resolved;
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        try {
            resolved = ASTDeferredIVResolution.resolveUpdate(conn.getTripleStore(), astContainer, (BindingSet)bs, dataset);
        }
        catch (MalformedQueryException e) {
            throw new UpdateExecutionException(e.getMessage(), (Throwable)e);
        }
        try {
            if (dataset != null) {
                ASTEvalHelper.applyDataSet(conn.getTripleStore(), astContainer, resolved.dataset);
            }
            AST2BOpUpdateContext ctx = new AST2BOpUpdateContext(astContainer, conn);
            ASTEvalHelper.doSparqlLogging(ctx);
            ctx.setIncludeInferred(includeInferred);
            IBindingSet[] bindingSets = ASTEvalHelper.toBindingSet(resolved.bindingSet);
            ctx.setQueryBindingSet(bs);
            ctx.setBindings(bindingSets);
            ctx.setDataset(dataset);
            AST2BOpUpdate.optimizeUpdateRoot(ctx);
            AST2BOpUpdate.convertUpdate(ctx);
            return ctx.getCommitTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new UpdateExecutionException((Throwable)ex);
        }
    }

    private static void applyDataSet(AbstractTripleStore tripleStore, ASTContainer astContainer, Dataset dataset) {
        if (tripleStore == null) {
            throw new IllegalArgumentException();
        }
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        if (dataset == null) {
            throw new IllegalArgumentException();
        }
        UpdateRoot updateRoot = astContainer.getOriginalUpdateAST();
        for (Update op : updateRoot) {
            if (!(op instanceof IDataSetNode)) continue;
            IDataSetNode node = (IDataSetNode)((Object)op);
            node.setDataset(new DatasetNode(dataset, true));
        }
    }

    private static void doSparqlLogging(AST2BOpContext ctx) {
        if (!log.isInfoEnabled()) {
            return;
        }
        ASTEvalHelper.setupLoggingContext(ctx);
        ASTContainer astContainer = ctx.astContainer;
        String queryString = astContainer.getQueryString();
        if (queryString != null) {
            log.info((Object)queryString);
        } else if (astContainer.isQuery()) {
            log.info((Object)astContainer.getOriginalAST());
        } else {
            log.info((Object)astContainer.getOriginalUpdateAST());
        }
        ASTEvalHelper.clearLoggingContext();
    }

    private static void setupLoggingContext(IEvaluationContext context) {
        MDC.put((String)"tx", (Object)TimestampUtility.toString(context.getTimestamp()));
    }

    private static void clearLoggingContext() {
        MDC.remove((String)"tx");
    }
}

