/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTGeoSpatialSearchOptimizer;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.optimizers.ASTRangeOptimizer;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.ChunkConsumerIterator;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import com.bigdata.service.fts.FulltextSearchException;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialCounters;
import com.bigdata.service.geospatial.IGeoSpatialQuery;
import com.bigdata.service.geospatial.ZOrderIndexBigMinAdvancer;
import com.bigdata.service.geospatial.impl.GeoSpatialQuery;
import com.bigdata.service.geospatial.impl.GeoSpatialUtility;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.concurrent.Haltable;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class GeoSpatialServiceFactory
extends AbstractServiceFactoryBase {
    private static final Logger log = Logger.getLogger(GeoSpatialServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public GeoSpatialServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public BigdataServiceCall create(ServiceCallCreateParams createParams) {
        if (createParams == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = createParams.getTripleStore();
        Properties props = store.getIndexManager() != null && store.getIndexManager() instanceof AbstractJournal ? ((AbstractJournal)store.getIndexManager()).getProperties() : null;
        GeoSpatialDefaults dflts = new GeoSpatialDefaults(props);
        ServiceNode serviceNode = createParams.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        Map<IVariable<?>, Map<URI, StatementPatternNode>> map = this.verifyGraphPattern(store, serviceNode.getGraphPattern());
        if (map == null) {
            throw new RuntimeException("Not a geospatial service request.");
        }
        if (map.size() != 1) {
            throw new RuntimeException("Multiple geospatial service requests may not be combined.");
        }
        Map.Entry<IVariable<?>, Map<URI, StatementPatternNode>> e = map.entrySet().iterator().next();
        IVariable<?> searchVar = e.getKey();
        Map<URI, StatementPatternNode> statementPatterns = e.getValue();
        this.validateSearch(searchVar, statementPatterns);
        Integer maxParallel = serviceNode.getQueryHintAsInteger(PipelineOp.Annotations.MAX_PARALLEL, 5);
        Integer minDatapointsPerTask = serviceNode.getQueryHintAsInteger(PipelineJoin.Annotations.MIN_DATAPOINTS_PER_TASK, 100000);
        Integer numTasksPerThread = serviceNode.getQueryHintAsInteger(PipelineJoin.Annotations.NUM_TASKS_PER_THREAD, 1);
        Integer threadLocalBufferCapacity = serviceNode.getQueryHintAsInteger(BufferAnnotations.CHUNK_CAPACITY, 100);
        Integer globalBufferChunkOfChunksCapacity = serviceNode.getQueryHintAsInteger(BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY, 5);
        if (log.isDebugEnabled()) {
            log.debug((Object)("maxParallel=" + maxParallel));
            log.debug((Object)("numTasksPerThread=" + numTasksPerThread));
            log.debug((Object)("threadLocalBufferCapacity=" + threadLocalBufferCapacity));
            log.debug((Object)("globalBufferChunkOfChunksCapacity=" + globalBufferChunkOfChunksCapacity));
        }
        return new GeoSpatialServiceCall(searchVar, statementPatterns, this.getServiceOptions(), dflts, store, maxParallel, numTasksPerThread * maxParallel, minDatapointsPerTask, threadLocalBufferCapacity, globalBufferChunkOfChunksCapacity, createParams.getStats());
    }

    private Map<IVariable<?>, Map<URI, StatementPatternNode>> verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            LinkedHashMap<URI, StatementPatternNode> statementPatterns;
            BOp child = group.get(i);
            if (child instanceof GroupNodeBase) {
                throw new RuntimeException("Nested groups are not allowed.");
            }
            if (!(child instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)child;
            TermNode p = sp.p();
            if (!p.isConstant()) {
                throw new RuntimeException("Expecting geospatial predicate: " + sp);
            }
            URI uri = (URI)((ConstantNode)p).getValue();
            if (!uri.stringValue().startsWith("http://www.bigdata.com/rdf/geospatial#")) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            if (!ASTGeoSpatialSearchOptimizer.searchUris.contains(uri)) {
                throw new RuntimeException("Unknown search predicate: " + uri);
            }
            TermNode s = sp.s();
            if (!s.isVariable()) {
                throw new RuntimeException("Subject of search predicate is constant: " + sp);
            }
            IVariable<IV> searchVar = ((VarNode)s).getValueExpression();
            if (tmp == null) {
                tmp = new LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>>();
            }
            if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                tmp.put(searchVar, statementPatterns);
            }
            statementPatterns.put(uri, sp);
        }
        return tmp;
    }

    private void validateSearch(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (StatementPatternNode sp : statementPatterns.values()) {
            URI uri = (URI)sp.p().getValue();
            if (!uris.add(uri)) {
                throw new RuntimeException("Search predicate appears multiple times for same search variable: predicate=" + uri + ", searchVar=" + searchVar);
            }
            if (uri.equals((Object)GeoSpatial.PREDICATE) || uri.equals((Object)GeoSpatial.CONTEXT)) {
                this.assertObjectIsURI(sp);
                continue;
            }
            if (uri.equals((Object)GeoSpatial.LOCATION_VALUE) || uri.equals((Object)GeoSpatial.TIME_VALUE) || uri.equals((Object)GeoSpatial.LOCATION_AND_TIME_VALUE)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            this.assertObjectIsLiteralOrVariable(sp);
        }
        if (!uris.contains(GeoSpatial.SEARCH)) {
            throw new RuntimeException("Required search predicate not found: " + GeoSpatial.SEARCH + " for searchVar=" + searchVar);
        }
        if (!uris.contains(GeoSpatial.PREDICATE)) {
            throw new RuntimeException("GeoSpatial search with unbound predicate is currenly not supported.");
        }
    }

    private void assertObjectIsURI(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (o instanceof URI) {
            throw new IllegalArgumentException("Object is not a URI: " + sp);
        }
    }

    private void assertObjectIsLiteralOrVariable(StatementPatternNode sp) {
        boolean isNotVariable;
        TermNode o = sp.o();
        boolean isNotLiterale = !o.isConstant() || !(((ConstantNode)o).getValue() instanceof Literal);
        boolean bl = isNotVariable = !o.isVariable();
        if (isNotLiterale && isNotVariable) {
            throw new IllegalArgumentException("Object is not literal or variable: " + sp);
        }
    }

    private void assertObjectIsVariable(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isVariable()) {
            throw new IllegalArgumentException("Object is not a variable: " + sp);
        }
    }

    Collection<StatementPatternNode> getStatementPatterns(ServiceNode serviceNode) {
        ArrayList<StatementPatternNode> statementPatterns = new ArrayList<StatementPatternNode>();
        for (IGroupMemberNode child : serviceNode.getGraphPattern()) {
            if (child instanceof StatementPatternNode) {
                statementPatterns.add((StatementPatternNode)child);
                continue;
            }
            throw new FulltextSearchException("Nested groups are not allowed.");
        }
        return statementPatterns;
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        HashSet requiredBound = new HashSet();
        for (StatementPatternNode sp : this.getStatementPatterns(serviceNode)) {
            URI predicate = (URI)sp.p().getValue();
            IVariableOrConstant<IV> object = sp.o().getValueExpression();
            if (!(object instanceof IVariable) || !predicate.equals((Object)GeoSpatial.PREDICATE) && !predicate.equals((Object)GeoSpatial.CONTEXT) && !predicate.equals((Object)GeoSpatial.SEARCH) && !predicate.equals((Object)GeoSpatial.SPATIAL_CIRCLE_CENTER) && !predicate.equals((Object)GeoSpatial.SPATIAL_CIRCLE_RADIUS) && !predicate.equals((Object)GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST) && !predicate.equals((Object)GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST) && !predicate.equals((Object)GeoSpatial.SPATIAL_UNIT) && !predicate.equals((Object)GeoSpatial.TIME_START) && !predicate.equals((Object)GeoSpatial.TIME_END) && !predicate.equals((Object)GeoSpatial.TIME_VALUE) && !predicate.equals((Object)GeoSpatial.LOCATION_VALUE) && !predicate.equals((Object)GeoSpatial.LOCATION_AND_TIME_VALUE)) continue;
            requiredBound.add((IVariable)object);
        }
        return requiredBound;
    }

    public static class GeoSpatialInRectangleFilter
    extends GeoSpatialFilterBase {
        private static final long serialVersionUID = -314581671447912352L;
        private final GeoSpatialUtility.PointLatLonTime lowerBorder;
        private final GeoSpatialUtility.PointLatLonTime upperBorder;

        public GeoSpatialInRectangleFilter(GeoSpatialUtility.PointLatLonTime lowerBorder, GeoSpatialUtility.PointLatLonTime upperBorder, GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            super(litExt, geoSpatialCounters);
            this.lowerBorder = lowerBorder;
            this.upperBorder = upperBorder;
        }

        @Override
        protected boolean isValidInternal(ITuple tuple) {
            return true;
        }
    }

    public static class GeoSpatialInCircleFilter
    extends GeoSpatialFilterBase {
        private static final long serialVersionUID = -346928614528045113L;
        private final double spatialPointLat;
        private final double spatialPointLon;
        private final Double distanceInMeters;
        private final Long timeMin;
        private final Long timeMax;

        public GeoSpatialInCircleFilter(GeoSpatialUtility.PointLatLon spatialPoint, Double distance, ICoordinate.UNITS unit, Long timeMin, Long timeMax, GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            super(litExt, geoSpatialCounters);
            this.spatialPointLat = spatialPoint.getLat();
            this.spatialPointLon = spatialPoint.getLon();
            this.distanceInMeters = CoordinateUtility.unitsToMeters(distance, unit);
            this.timeMin = timeMin;
            this.timeMax = timeMax;
        }

        @Override
        protected boolean isValidInternal(ITuple tuple) {
            try {
                byte[] key = tuple.getKey();
                IV[] ivs = IVUtility.decode(key, this.objectPos + 1);
                IV oIV = ivs[this.objectPos];
                if (!(oIV instanceof LiteralExtensionIV)) {
                    throw new IllegalArgumentException("Invalid IV cannot be cast to LiteralExtensionIV");
                }
                LiteralExtensionIV lit = (LiteralExtensionIV)oIV;
                long[] longArr = this.litExt.asLongArray(lit);
                Object[] components = this.litExt.longArrAsComponentArr(longArr);
                double lat = (Double)components[0];
                double lon = (Double)components[1];
                long time = (Long)components[2];
                return CoordinateUtility.distanceInMeters(lat, this.spatialPointLat, lon, this.spatialPointLon) <= this.distanceInMeters && this.timeMin <= time && time <= this.timeMax;
            }
            catch (Exception e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Something went wrong extracting the object: " + e.getMessage() + "Rejecting unprocessable value."));
                }
                return false;
            }
        }
    }

    public static abstract class GeoSpatialFilterBase
    extends TupleFilter {
        private static final long serialVersionUID = 2271038531634362860L;
        protected final GeoSpatialLiteralExtension<BigdataValue> litExt;
        protected int objectPos = -1;
        Integer contextPos = null;
        BigdataURI context = null;
        GeoSpatialCounters geoSpatialCounters;

        public GeoSpatialFilterBase(GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            this.litExt = litExt;
            this.geoSpatialCounters = geoSpatialCounters;
        }

        public void addContextCheck(Integer contextPos, BigdataURI context) {
            this.contextPos = contextPos;
            this.context = context;
        }

        public void setObjectPos(int objectPos) {
            this.objectPos = objectPos;
        }

        public GeoSpatialLiteralExtension<BigdataValue> getGeoSpatialLiteralExtension() {
            return this.litExt;
        }

        protected final boolean isValid(ITuple tuple) {
            long filterStartTime = System.nanoTime();
            if (!this.contextIsValid(tuple)) {
                return false;
            }
            boolean isValid = this.isValidInternal(tuple);
            long filterEndTime = System.nanoTime();
            this.geoSpatialCounters.addFilterCalculationTime(filterEndTime - filterStartTime);
            return isValid;
        }

        private boolean contextIsValid(ITuple tuple) {
            if (this.contextPos == null || this.context == null) {
                return true;
            }
            byte[] key = tuple.getKey();
            IV[] ivs = IVUtility.decode(key, this.contextPos + 1);
            IV contextIV = ivs[this.contextPos];
            return contextIV.equals(this.context.getIV());
        }

        protected abstract boolean isValidInternal(ITuple var1);
    }

    public static class GeoSpatialDefaults {
        private final String defaultFunction;
        private final String defaultSpatialUnit;

        public GeoSpatialDefaults(Properties p) {
            this.defaultFunction = p.getProperty(GeoSpatial.Options.GEO_FUNCTION);
            this.defaultSpatialUnit = p.getProperty(GeoSpatial.Options.GEO_SPATIAL_UNIT);
        }

        public String getDefaultFunction() {
            return this.defaultFunction;
        }

        public String getDefaultSpatialDistanceUnit() {
            return this.defaultSpatialUnit;
        }
    }

    public static class GeoSpatialInputBindingsIterator
    implements ICloseableIterator<IBindingSet> {
        private final IBindingSet[] bindingSet;
        private final TermNode searchFunction;
        private final IVariable<?> searchVar;
        private final TermNode predicate;
        private final TermNode context;
        private final TermNode spatialCircleCenter;
        private final TermNode spatialCircleRadius;
        private final TermNode spatialRectangleUpperLeft;
        private final TermNode spatialRectangleLowerRight;
        private final TermNode spatialUnit;
        private final TermNode timeStart;
        private final TermNode timeEnd;
        private final IVariable<?> locationVar;
        private final IVariable<?> timeVar;
        private final IVariable<?> locationAndTimeVar;
        final GeoSpatialDefaults defaults;
        final AbstractTripleStore kb;
        final GeoSpatialServiceCall serviceCall;
        int nextBindingSetItr = 0;
        ICloseableIterator<IBindingSet> curDelegate;

        public GeoSpatialInputBindingsIterator(IBindingSet[] bindingSet, TermNode searchFunction, IVariable<?> searchVar, TermNode predicate, TermNode context, TermNode spatialCircleCenter, TermNode spatialCircleRadius, TermNode spatialRectangleUpperLeft, TermNode spatialRectangleLowerRight, TermNode spatialUnit, TermNode timeStart, TermNode timeEnd, IVariable<?> locationVar, IVariable<?> timeVar, IVariable<?> locationAndTimeVar, GeoSpatialDefaults defaults, AbstractTripleStore kb, GeoSpatialServiceCall serviceCall) {
            this.bindingSet = bindingSet;
            this.searchFunction = searchFunction;
            this.searchVar = searchVar;
            this.predicate = predicate;
            this.context = context;
            this.spatialCircleCenter = spatialCircleCenter;
            this.spatialCircleRadius = spatialCircleRadius;
            this.spatialRectangleUpperLeft = spatialRectangleUpperLeft;
            this.spatialRectangleLowerRight = spatialRectangleLowerRight;
            this.spatialUnit = spatialUnit;
            this.timeStart = timeStart;
            this.timeEnd = timeEnd;
            this.locationVar = locationVar;
            this.timeVar = timeVar;
            this.locationAndTimeVar = locationAndTimeVar;
            this.defaults = defaults;
            this.kb = kb;
            this.serviceCall = serviceCall;
            this.init();
        }

        public boolean hasNext() {
            if (this.curDelegate == null) {
                return false;
            }
            if (this.curDelegate.hasNext()) {
                return true;
            }
            if (this.nextDelegate()) {
                return this.hasNext();
            }
            return false;
        }

        public IBindingSet next() {
            if (this.curDelegate == null) {
                return null;
            }
            if (this.curDelegate.hasNext()) {
                return (IBindingSet)this.curDelegate.next();
            }
            if (this.nextDelegate()) {
                return this.next();
            }
            return null;
        }

        private boolean nextDelegate() {
            if (this.bindingSet == null || this.nextBindingSetItr >= this.bindingSet.length) {
                this.curDelegate = null;
                return false;
            }
            IBindingSet bs = this.bindingSet[this.nextBindingSetItr++];
            GeoSpatial.GeoFunction searchFunction = this.resolveAsGeoFunction(this.searchFunction, bs);
            GeoSpatialUtility.PointLatLon spatialCircleCenter = this.resolveAsPoint(this.spatialCircleCenter, bs);
            Double spatialCircleRadius = this.resolveAsDouble(this.spatialCircleRadius, bs);
            GeoSpatialUtility.PointLatLon spatialRectangleUpperLeft = this.resolveAsPoint(this.spatialRectangleUpperLeft, bs);
            GeoSpatialUtility.PointLatLon spatialRectangleLowerRight = this.resolveAsPoint(this.spatialRectangleLowerRight, bs);
            ICoordinate.UNITS spatialUnit = this.resolveAsSpatialDistanceUnit(this.spatialUnit, bs);
            Long timeStart = this.resolveAsLong(this.timeStart, bs);
            Long timeEnd = this.resolveAsLong(this.timeEnd, bs);
            GeoSpatialQuery sq = new GeoSpatialQuery(searchFunction, bs.get(this.searchVar), this.predicate, this.context, spatialCircleCenter, spatialCircleRadius, spatialRectangleUpperLeft, spatialRectangleLowerRight, spatialUnit, timeStart, timeEnd, this.locationVar, this.timeVar, this.locationAndTimeVar, bs);
            this.curDelegate = this.serviceCall.search(sq, this.kb);
            return true;
        }

        private void init() {
            this.nextDelegate();
        }

        private GeoSpatial.GeoFunction resolveAsGeoFunction(TermNode termNode, IBindingSet bs) {
            block4: {
                String geoFunctionStr = this.resolveAsString(termNode, bs);
                if (geoFunctionStr == null) {
                    geoFunctionStr = this.defaults.getDefaultFunction();
                }
                if (geoFunctionStr != null && !geoFunctionStr.isEmpty()) {
                    try {
                        return GeoSpatial.GeoFunction.forName(geoFunctionStr);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isInfoEnabled()) break block4;
                        log.info((Object)("Illegal geo function: " + geoFunctionStr + " -> will be ignored, using default."));
                    }
                }
            }
            return GeoSpatial.Options.DEFAULT_GEO_FUNCTION;
        }

        private ICoordinate.UNITS resolveAsSpatialDistanceUnit(TermNode termNode, IBindingSet bs) {
            block4: {
                String spatialUnitStr = this.resolveAsString(termNode, bs);
                if (spatialUnitStr == null) {
                    spatialUnitStr = this.defaults.getDefaultSpatialDistanceUnit();
                }
                if (spatialUnitStr != null && !spatialUnitStr.isEmpty()) {
                    try {
                        return ICoordinate.UNITS.valueOf(spatialUnitStr);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isInfoEnabled()) break block4;
                        log.info((Object)("Illegal spatial unit: " + spatialUnitStr + " -> will be ignored, using default."));
                    }
                }
            }
            return GeoSpatial.Options.DEFAULT_GEO_SPATIAL_UNIT;
        }

        private Double resolveAsDouble(TermNode termNode, IBindingSet bs) {
            String s = this.resolveAsString(termNode, bs);
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Illegal double value: " + s + " -> will be ignored, using default."));
                }
                return null;
            }
        }

        private Long resolveAsLong(TermNode termNode, IBindingSet bs) {
            String s = this.resolveAsString(termNode, bs);
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Illegal double value: " + s + " -> will be ignored, using default."));
                }
                return null;
            }
        }

        private GeoSpatialUtility.PointLatLon resolveAsPoint(TermNode termNode, IBindingSet bs) {
            String pointAsStr = this.resolveAsString(termNode, bs);
            if (pointAsStr == null || pointAsStr.isEmpty()) {
                return null;
            }
            try {
                return new GeoSpatialUtility.PointLatLon(pointAsStr);
            }
            catch (NumberFormatException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Illegal point value: " + pointAsStr + " -> will be ignored, using default."));
                }
                return null;
            }
        }

        private String resolveAsString(TermNode termNode, IBindingSet bs) {
            if (termNode == null) {
                return null;
            }
            if (termNode.isConstant()) {
                Literal lit = (Literal)termNode.getValue();
                return lit == null ? null : lit.stringValue();
            }
            if (bs == null) {
                return null;
            }
            IVariable var = (IVariable)termNode.getValueExpression();
            if (bs.isBound(var)) {
                IConstant c = bs.get(var);
                if (c == null || c.get() == null || !(c.get() instanceof TermId)) {
                    return null;
                }
                TermId cAsTerm = (TermId)c.get();
                return cAsTerm.stringValue();
            }
            throw new FulltextSearchException("Service magic variable unbound at runtime:" + var);
        }

        public void remove() {
            if (this.curDelegate != null) {
                this.curDelegate.remove();
            }
        }

        public void close() {
            if (this.curDelegate != null) {
                this.curDelegate.close();
            }
        }
    }

    private static class GeoSpatialServiceCall
    implements BigdataServiceCall {
        private final IServiceOptions serviceOptions;
        private final TermNode searchFunction;
        private final IVariable<?> searchVar;
        private final IVariable<?> locationVar;
        private final IVariable<?> timeVar;
        private final IVariable<?> locationAndTimeVar;
        private final TermNode predicate;
        private final TermNode context;
        private final TermNode spatialCircleCenter;
        private final TermNode spatialCircleRadius;
        private final TermNode spatialRectangleSouthWest;
        private final TermNode spatialRectangleNorthEast;
        private final TermNode spatialUnit;
        private final TermNode timeStart;
        private final TermNode timeEnd;
        private IVariable<?>[] vars;
        private final GeoSpatialDefaults defaults;
        private final AbstractTripleStore kb;
        private final GeoSpatialCounters geoSpatialCounters;
        private final int numTasks;
        private final int minDatapointsPerTask;
        private final int threadLocalBufferCapacity;
        private final int globalBufferChunkOfChunksCapacity;
        private final BaseJoinStats stats;
        private final Executor executor;

        public GeoSpatialServiceCall(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns, IServiceOptions serviceOptions, GeoSpatialDefaults dflts, AbstractTripleStore kb, int maxParallel, int numTasks, int minDatapointsPerTask, int threadLocalBufferCapacity, int globalBufferChunkOfChunksCapacity, BaseJoinStats stats) {
            if (searchVar == null) {
                throw new IllegalArgumentException();
            }
            if (statementPatterns == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            if (kb == null) {
                throw new IllegalArgumentException();
            }
            this.serviceOptions = serviceOptions;
            this.defaults = dflts;
            this.searchVar = searchVar;
            StatementPatternNode sp = statementPatterns.get(GeoSpatial.SEARCH);
            this.searchFunction = sp.o();
            TermNode predicate = null;
            TermNode context = null;
            TermNode spatialCircleCenter = null;
            TermNode spatialCircleRadius = null;
            TermNode spatialRectangleSouthWest = null;
            TermNode spatialRectangleNorthEast = null;
            TermNode spatialUnit = null;
            TermNode timeStart = null;
            TermNode timeEnd = null;
            IVariable locationVar = null;
            IVariable timeVar = null;
            IVariable locationAndTimeVar = null;
            for (StatementPatternNode meta : statementPatterns.values()) {
                IVariable oVar;
                URI p = (URI)meta.p().getValue();
                IVariable iVariable = oVar = meta.o().isVariable() ? (IVariable)meta.o().getValueExpression() : null;
                if (GeoSpatial.PREDICATE.equals((Object)p)) {
                    predicate = meta.o();
                    continue;
                }
                if (GeoSpatial.CONTEXT.equals((Object)p)) {
                    context = meta.o();
                    continue;
                }
                if (GeoSpatial.SPATIAL_CIRCLE_CENTER.equals((Object)p)) {
                    spatialCircleCenter = meta.o();
                    continue;
                }
                if (GeoSpatial.SPATIAL_CIRCLE_RADIUS.equals((Object)p)) {
                    spatialCircleRadius = meta.o();
                    continue;
                }
                if (GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST.equals((Object)p)) {
                    spatialRectangleSouthWest = meta.o();
                    continue;
                }
                if (GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST.equals((Object)p)) {
                    spatialRectangleNorthEast = meta.o();
                    continue;
                }
                if (GeoSpatial.SPATIAL_UNIT.equals((Object)p)) {
                    spatialUnit = meta.o();
                    continue;
                }
                if (GeoSpatial.TIME_START.equals((Object)p)) {
                    timeStart = meta.o();
                    continue;
                }
                if (GeoSpatial.TIME_END.equals((Object)p)) {
                    timeEnd = meta.o();
                    continue;
                }
                if (GeoSpatial.LOCATION_VALUE.equals((Object)p)) {
                    locationVar = oVar;
                    continue;
                }
                if (GeoSpatial.TIME_VALUE.equals((Object)p)) {
                    timeVar = oVar;
                    continue;
                }
                if (!GeoSpatial.LOCATION_AND_TIME_VALUE.equals((Object)p)) continue;
                locationAndTimeVar = oVar;
            }
            this.vars = new IVariable[]{searchVar};
            this.predicate = predicate;
            this.context = context;
            this.spatialCircleCenter = spatialCircleCenter;
            this.spatialCircleRadius = spatialCircleRadius;
            this.spatialRectangleSouthWest = spatialRectangleSouthWest;
            this.spatialRectangleNorthEast = spatialRectangleNorthEast;
            this.spatialUnit = spatialUnit;
            this.timeStart = timeStart;
            this.timeEnd = timeEnd;
            this.locationVar = locationVar;
            this.timeVar = timeVar;
            this.locationAndTimeVar = locationAndTimeVar;
            this.kb = kb;
            this.geoSpatialCounters = QueryEngineFactory.getInstance().getQueryController(kb.getIndexManager()).getGeoSpatialCounters();
            this.numTasks = numTasks;
            this.minDatapointsPerTask = minDatapointsPerTask;
            this.threadLocalBufferCapacity = threadLocalBufferCapacity;
            this.globalBufferChunkOfChunksCapacity = globalBufferChunkOfChunksCapacity;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of threads used for execution: " + maxParallel));
            }
            this.executor = maxParallel <= 1 ? null : new LatchedExecutor(kb.getIndexManager().getExecutorService(), maxParallel);
            this.stats = stats;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] incomingBs) {
            return new GeoSpatialInputBindingsIterator(incomingBs, this.searchFunction, this.searchVar, this.predicate, this.context, this.spatialCircleCenter, this.spatialCircleRadius, this.spatialRectangleSouthWest, this.spatialRectangleNorthEast, this.spatialUnit, this.timeStart, this.timeEnd, this.locationVar, this.timeVar, this.locationAndTimeVar, this.defaults, this.kb, this);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        public ICloseableIterator<IBindingSet> search(GeoSpatialQuery query, AbstractTripleStore kb) {
            BOpContextBase context = new BOpContextBase(QueryEngineFactory.getInstance().getQueryController(kb.getIndexManager()));
            this.geoSpatialCounters.registerGeoSpatialSearchRequest();
            GlobalAnnotations globals = new GlobalAnnotations(kb.getLexiconRelation().getNamespace(), kb.getSPORelation().getTimestamp());
            BigdataValueFactory vf = kb.getValueFactory();
            BlockingBuffer<IBindingSet[]> buffer = new BlockingBuffer<IBindingSet[]>(this.globalBufferChunkOfChunksCapacity);
            FutureTask<Void> ft = new FutureTask<Void>(new GeoSpatialServiceCallTask(buffer, query.normalize(), kb, this.vars, context, globals, vf, this.geoSpatialCounters, this.executor, this.numTasks, this.minDatapointsPerTask, this.threadLocalBufferCapacity, this.stats));
            buffer.setFuture(ft);
            kb.getIndexManager().getExecutorService().submit(ft);
            return new ChunkConsumerIterator<IBindingSet>(buffer.iterator());
        }

        private static Var<?> varFromIVar(IVariable<?> iVar) {
            return iVar == null ? null : Var.var(iVar.getName());
        }

        private static class GeoSpatialServiceCallResolver
        extends Resolver {
            private static final long serialVersionUID = 1L;
            private final Var<?> var;
            private final IBindingSet incomingBindingSet;
            private final Var<?> locationVar;
            private final Var<?> timeVar;
            private final Var<?> locationAndTimeVar;
            private final int subjectPos;
            private final int objectPos;
            private final BigdataValueFactory vf;
            private final GeoSpatialLiteralExtension<BigdataValue> litExt;
            final boolean reportsObjectComponents;
            private final int extractToPosition;

            public GeoSpatialServiceCallResolver(Var<?> var, IBindingSet incomingBindingSet, Var<?> locationVar, Var<?> timeVar, Var<?> locationAndTimeVar, int subjectPos, int objectPos, BigdataValueFactory vf, GeoSpatialLiteralExtension<BigdataValue> litExt) {
                this.var = var;
                this.incomingBindingSet = incomingBindingSet;
                this.locationVar = locationVar;
                this.timeVar = timeVar;
                this.locationAndTimeVar = locationAndTimeVar;
                this.subjectPos = subjectPos;
                this.objectPos = objectPos;
                this.vf = vf;
                this.litExt = litExt;
                this.reportsObjectComponents = locationVar != null || timeVar != null || locationAndTimeVar != null;
                this.extractToPosition = this.reportsObjectComponents ? Math.max(objectPos, subjectPos) + 1 : subjectPos + 1;
            }

            protected IBindingSet resolve(Object obj) {
                byte[] key = ((ITuple)obj).getKey();
                IV[] ivs = IVUtility.decode(key, this.extractToPosition);
                IBindingSet bs = this.incomingBindingSet.clone();
                bs.set(this.var, new Constant<IV>(ivs[this.subjectPos]));
                if (this.reportsObjectComponents) {
                    if (this.locationVar != null) {
                        BigdataLiteral locationLit = this.vf.createLiteral(this.litExt.toComponentString(0, 1, (LiteralExtensionIV)ivs[this.objectPos]));
                        bs.set(this.locationVar, new Constant<IV>(DummyConstantNode.toDummyIV(locationLit)));
                    }
                    if (this.timeVar != null) {
                        BigdataLiteral timeLit = this.vf.createLiteral(Long.valueOf(this.litExt.toComponentString(2, 2, (LiteralExtensionIV)ivs[this.objectPos])));
                        bs.set(this.timeVar, new Constant<IV>(DummyConstantNode.toDummyIV(timeLit)));
                    }
                    if (this.locationAndTimeVar != null) {
                        bs.set(this.locationAndTimeVar, new Constant<IV>(ivs[this.objectPos]));
                    }
                }
                return bs;
            }
        }

        private static class GeoSpatialServiceCallTask
        extends Haltable<Void>
        implements Callable<Void> {
            final BlockingBuffer<IBindingSet[]> buffer;
            private final Executor executor;
            private final List<IGeoSpatialQuery> queries;
            private final AbstractTripleStore kb;
            private final IVariable<?>[] vars;
            private final GeoSpatialCounters geoSpatialCounters;
            private final BOpContextBase context;
            private final GlobalAnnotations globals;
            private final BigdataValueFactory vf;
            private final GeoSpatialLiteralExtension<BigdataValue> litExt;
            private final int numTasks;
            private final int minDatapointsPerTask;
            private final int threadLocalBufferCapacity;
            private final BaseJoinStats stats;
            private final List<GeoSpatialServiceCallSubRangeTask> tasks;

            public GeoSpatialServiceCallTask(BlockingBuffer<IBindingSet[]> buffer, List<IGeoSpatialQuery> queries, AbstractTripleStore kb, IVariable<?>[] vars, BOpContextBase context, GlobalAnnotations globals, BigdataValueFactory vf, GeoSpatialCounters geoSpatialCounters, Executor executor, int numTasks, int minDatapointsPerTask, int threadLocalBufferCapacity, BaseJoinStats stats) {
                this.buffer = buffer;
                this.queries = queries;
                this.kb = kb;
                this.vars = vars;
                this.context = context;
                this.globals = globals;
                this.vf = vf;
                this.executor = executor;
                this.geoSpatialCounters = geoSpatialCounters;
                this.litExt = new GeoSpatialLiteralExtension(kb.getLexiconRelation());
                this.numTasks = numTasks;
                this.minDatapointsPerTask = minDatapointsPerTask;
                this.threadLocalBufferCapacity = threadLocalBufferCapacity;
                this.stats = stats;
                this.tasks = this.getSubTasks();
                geoSpatialCounters.registerGeoSpatialServiceCallTask();
                geoSpatialCounters.registerGeoSpatialServiceCallSubRangeTasks(this.tasks.size());
            }

            protected List<GeoSpatialServiceCallSubRangeTask> getSubTasks() {
                LinkedList<GeoSpatialServiceCallSubRangeTask> subTasks = new LinkedList<GeoSpatialServiceCallSubRangeTask>();
                for (IGeoSpatialQuery query : this.queries) {
                    GeoSpatialUtility.PointLatLonTime northEastWithTime;
                    Object[] northEastComponents;
                    if (!query.isNormalized()) {
                        throw new IllegalArgumentException("Expected list of normalized query as input.");
                    }
                    GeoSpatialUtility.PointLatLonTime southWestWithTime = query.getBoundingBoxSouthWestWithTime();
                    Object[] southWestComponents = GeoSpatialUtility.PointLatLonTime.toComponentString(southWestWithTime);
                    AccessPath<ISPO> accessPath = this.getAccessPath(southWestComponents, northEastComponents = GeoSpatialUtility.PointLatLonTime.toComponentString(northEastWithTime = query.getBoundingBoxNorthEastWithTime()), query);
                    if (accessPath == null) continue;
                    long totalPointsInRange = accessPath.rangeCount(false);
                    this.stats.accessPathRangeCount.add(totalPointsInRange);
                    long maxTasksByDatapointRestriction = totalPointsInRange / (long)this.minDatapointsPerTask;
                    long desiredNumTasks = Math.max(this.numTasks, 1);
                    long nrSubRanges = Math.min(maxTasksByDatapointRestriction, desiredNumTasks);
                    LiteralExtensionIV lowerBorderIV = this.litExt.createIV(southWestComponents);
                    LiteralExtensionIV upperBorderIV = this.litExt.createIV(northEastComponents);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[OuterRange] Scanning from " + lowerBorderIV.getDelegate().integerValue() + " / " + this.litExt.toComponentString(0, 2, lowerBorderIV)));
                        log.debug((Object)("[OuterRange]            to " + upperBorderIV.getDelegate().integerValue() + " / " + this.litExt.toComponentString(0, 2, upperBorderIV)));
                    }
                    GeoSpatialSubRangePartitioner partitioner = new GeoSpatialSubRangePartitioner(southWestWithTime, northEastWithTime, nrSubRanges, this.litExt);
                    SPOKeyOrder keyOrder = (SPOKeyOrder)accessPath.getKeyOrder();
                    int subjectPos = keyOrder.getPositionInIndex(0);
                    int objectPos = keyOrder.getPositionInIndex(2);
                    for (GeoSpatialSubRangePartition partition : partitioner.getPartitions()) {
                        GeoSpatialServiceCallSubRangeTask subTask = this.getSubTask(southWestWithTime, northEastWithTime, partition.lowerBorder, partition.upperBorder, keyOrder, subjectPos, objectPos, this.stats, query);
                        if (subTask != null) {
                            subTasks.add(subTask);
                        }
                        if (!log.isDebugEnabled()) continue;
                        Object[] lowerBorderComponentsPart = GeoSpatialUtility.PointLatLonTime.toComponentString(partition.lowerBorder);
                        Object[] upperBorderComponentsPart = GeoSpatialUtility.PointLatLonTime.toComponentString(partition.upperBorder);
                        LiteralExtensionIV lowerBorderIVPart = this.litExt.createIV(lowerBorderComponentsPart);
                        LiteralExtensionIV upperBorderIVPart = this.litExt.createIV(upperBorderComponentsPart);
                        log.debug((Object)("[InnerRange] Scanning from " + lowerBorderIVPart.getDelegate().integerValue() + " / " + this.litExt.toComponentString(0, 2, lowerBorderIVPart) + " / " + BytesUtil.byteArrToBinaryStr((byte[])this.litExt.toZOrderByteArray(lowerBorderComponentsPart))));
                        log.debug((Object)("[InnerRange]            to " + upperBorderIVPart.getDelegate().integerValue() + " / " + this.litExt.toComponentString(0, 2, upperBorderIVPart) + " / " + BytesUtil.byteArrToBinaryStr((byte[])this.litExt.toZOrderByteArray(upperBorderComponentsPart))));
                    }
                }
                return subTasks;
            }

            protected GeoSpatialServiceCallSubRangeTask getSubTask(GeoSpatialUtility.PointLatLonTime outerRangeUpperLeftWithTime, GeoSpatialUtility.PointLatLonTime outerRangeLowerRightWithTime, GeoSpatialUtility.PointLatLonTime subRangeUpperLeftWithTime, GeoSpatialUtility.PointLatLonTime subRangeLowerRightWithTime, SPOKeyOrder keyOrder, int subjectPos, int objectPos, BaseJoinStats stats, IGeoSpatialQuery query) {
                Object[] subRangeLowerRightComponents;
                Object[] subRangeUpperLeftComponents;
                AccessPath<ISPO> accessPath;
                GeoSpatialFilterBase filter;
                switch (query.getSearchFunction()) {
                    case IN_CIRCLE: {
                        filter = new GeoSpatialInCircleFilter(query.getSpatialCircleCenter(), query.getSpatialCircleRadius(), query.getSpatialUnit(), outerRangeUpperLeftWithTime.getTimestamp(), outerRangeLowerRightWithTime.getTimestamp(), new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation()), this.geoSpatialCounters);
                        break;
                    }
                    case IN_RECTANGLE: {
                        filter = new GeoSpatialInRectangleFilter(outerRangeUpperLeftWithTime, outerRangeLowerRightWithTime, new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation()), this.geoSpatialCounters);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown geospatial search function.");
                    }
                }
                filter.setObjectPos(objectPos);
                TermNode ctxTermNode = query.getContext();
                if (ctxTermNode != null) {
                    BigdataValue ctx;
                    BigdataValue bigdataValue = ctx = ctxTermNode == null ? null : ctxTermNode.getValue();
                    if (ctx != null && !(ctx instanceof BigdataURI)) {
                        throw new IllegalArgumentException("Context in GeoSpatial search must be a URI");
                    }
                    filter.addContextCheck(keyOrder.getPositionInIndex(3), (BigdataURI)ctx);
                }
                if ((accessPath = this.getAccessPath(subRangeUpperLeftComponents = GeoSpatialUtility.PointLatLonTime.toComponentString(subRangeUpperLeftWithTime), subRangeLowerRightComponents = GeoSpatialUtility.PointLatLonTime.toComponentString(subRangeLowerRightWithTime), query)) == null) {
                    return null;
                }
                byte[] lowerZOrderKey = this.litExt.toZOrderByteArray(subRangeUpperLeftComponents);
                byte[] upperZOrderKey = this.litExt.toZOrderByteArray(subRangeLowerRightComponents);
                ZOrderIndexBigMinAdvancer bigMinAdvancer = new ZOrderIndexBigMinAdvancer(lowerZOrderKey, upperZOrderKey, this.litExt, objectPos, this.geoSpatialCounters);
                Var locationVar = GeoSpatialServiceCall.varFromIVar(query.getLocationVar());
                Var timeVar = GeoSpatialServiceCall.varFromIVar(query.getTimeVar());
                Var locationAndTimeVar = GeoSpatialServiceCall.varFromIVar(query.getLocationAndTimeVar());
                Var var = Var.var(this.vars[0].getName());
                IBindingSet incomingBindingSet = query.getIncomingBindings();
                GeoSpatialServiceCallResolver resolver = new GeoSpatialServiceCallResolver(var, incomingBindingSet, locationVar, timeVar, locationAndTimeVar, subjectPos, objectPos, this.vf, new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation()));
                return new GeoSpatialServiceCallSubRangeTask(this.buffer, accessPath, bigMinAdvancer, filter, resolver, this.threadLocalBufferCapacity, stats);
            }

            protected AccessPath<ISPO> getAccessPath(Object[] lowerBorderComponents, Object[] upperBorderComponents, IGeoSpatialQuery query) {
                Var<IV> oVar = Var.var();
                RangeNode range = new RangeNode(new VarNode(oVar), new ConstantNode(this.litExt.createIV(lowerBorderComponents)), new ConstantNode(this.litExt.createIV(upperBorderComponents)));
                RangeBOp rangeBop = ASTRangeOptimizer.toRangeBOp(this.context, range, this.globals);
                IConstant<?> constSubject = query.getSubject();
                TermNode s = constSubject == null ? new VarNode(this.vars[0].getName()) : new ConstantNode(constSubject);
                TermNode p = query.getPredicate();
                VarNode o = new VarNode(oVar);
                IPredicate pred = this.kb.getPredicate((Resource)((URI)s.getValue()), p == null ? null : (URI)p.getValue(), o.getValue(), null, null, rangeBop);
                if (pred == null) {
                    return null;
                }
                pred = (IPredicate)pred.setProperty(IPredicate.Annotations.TIMESTAMP, this.kb.getSPORelation().getTimestamp());
                IRelation relation = this.context.getRelation(pred);
                AccessPath accessPath = (AccessPath)this.context.getAccessPath(relation, pred);
                return accessPath;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of service call tasks to execute: " + this.tasks.size()));
                }
                if (this.executor == null || this.tasks.size() == 1) {
                    for (GeoSpatialServiceCallSubRangeTask task : this.tasks) {
                        task.call();
                    }
                    this.buffer.flush();
                    this.buffer.close();
                    return null;
                }
                LinkedList<FutureTask<Void>> futureTasks = new LinkedList<FutureTask<Void>>();
                for (GeoSpatialServiceCallSubRangeTask geoSpatialServiceCallSubRangeTask : this.tasks) {
                    FutureTask<Void> ft = new FutureTask<Void>(geoSpatialServiceCallSubRangeTask);
                    futureTasks.add(ft);
                }
                try {
                    for (FutureTask futureTask : futureTasks) {
                        this.halted();
                        this.executor.execute(futureTask);
                    }
                    for (FutureTask futureTask : futureTasks) {
                        if (this.isDone()) continue;
                        futureTask.get();
                    }
                }
                finally {
                    for (FutureTask futureTask : futureTasks) {
                        futureTask.cancel(true);
                    }
                }
                this.buffer.flush();
                this.buffer.close();
                return null;
            }

            public static class GeoSpatialSubRangePartition {
                final GeoSpatialUtility.PointLatLonTime lowerBorder;
                final GeoSpatialUtility.PointLatLonTime upperBorder;

                public GeoSpatialSubRangePartition(GeoSpatialUtility.PointLatLonTime lowerBorder, GeoSpatialUtility.PointLatLonTime upperBorder) {
                    this.lowerBorder = lowerBorder;
                    this.upperBorder = upperBorder;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer();
                    buf.append("lowerBorder=");
                    buf.append(this.lowerBorder.toString());
                    buf.append(", upperBorder=");
                    buf.append(this.upperBorder.toString());
                    return buf.toString();
                }
            }

            public static class GeoSpatialSubRangePartitioner {
                private List<GeoSpatialSubRangePartition> partitions = new ArrayList<GeoSpatialSubRangePartition>();

                public GeoSpatialSubRangePartitioner(GeoSpatialUtility.PointLatLonTime lowerBorder, GeoSpatialUtility.PointLatLonTime upperBorder, long numPartitions, GeoSpatialLiteralExtension<BigdataValue> litExt) {
                    long breakPoint;
                    long lowerTimestamp = lowerBorder.getTimestamp();
                    long upperTimestamp = upperBorder.getTimestamp();
                    long numPartitionsSafe = Math.max(1L, numPartitions);
                    long diff = upperTimestamp - lowerTimestamp;
                    long dist = diff / numPartitionsSafe;
                    ArrayList<Long> breakPoints = new ArrayList<Long>();
                    long lastConsidered = -1L;
                    breakPoints.add(lowerTimestamp - 1L);
                    for (long i = 1L; i < numPartitionsSafe && lastConsidered != (breakPoint = lowerTimestamp + i * dist); ++i) {
                        if (breakPoint > lowerTimestamp && breakPoint < upperTimestamp) {
                            breakPoints.add(breakPoint);
                        }
                        lastConsidered = breakPoint;
                    }
                    breakPoints.add(upperTimestamp);
                    for (int i = 0; i < breakPoints.size() - 1; ++i) {
                        this.partitions.add(new GeoSpatialSubRangePartition(new GeoSpatialUtility.PointLatLonTime(lowerBorder.getLat(), lowerBorder.getLon(), (Long)breakPoints.get(i) + 1L), new GeoSpatialUtility.PointLatLonTime(upperBorder.getLat(), upperBorder.getLon(), (Long)breakPoints.get(i + 1))));
                    }
                }

                public List<GeoSpatialSubRangePartition> getPartitions() {
                    return this.partitions;
                }
            }

            private static class GeoSpatialServiceCallSubRangeTask
            implements Callable<Void> {
                private final UnsynchronizedArrayBuffer<IBindingSet> localBuffer;
                private final AccessPath<ISPO> accessPath;
                private final Advancer<SPO> bigMinAdvancer;
                private final GeoSpatialFilterBase filter;
                private final GeoSpatialServiceCallResolver resolver;
                private final BaseJoinStats stats;

                public GeoSpatialServiceCallSubRangeTask(BlockingBuffer<IBindingSet[]> backingBuffer, AccessPath<ISPO> accessPath, Advancer<SPO> bigMinAdvancer, GeoSpatialFilterBase filter, GeoSpatialServiceCallResolver resolver, int threadLocalBufferCapacity, BaseJoinStats stats) {
                    this.localBuffer = new UnsynchronizedArrayBuffer<IBindingSet>(backingBuffer, IBindingSet.class, threadLocalBufferCapacity);
                    this.accessPath = accessPath;
                    this.bigMinAdvancer = bigMinAdvancer;
                    this.filter = filter;
                    this.resolver = resolver;
                    this.stats = stats;
                }

                @Override
                public Void call() throws Exception {
                    IStriterator itr = new Striterator((Iterator)this.accessPath.getIndex().rangeIterator(this.accessPath.getFromKey(), this.accessPath.getToKey(), 0, 33, this.bigMinAdvancer)).addFilter((IFilter)this.filter).addFilter((IFilter)this.resolver);
                    this.stats.accessPathCount.increment();
                    while (itr.hasNext()) {
                        this.stats.accessPathUnitsIn.increment();
                        this.localBuffer.add((IBindingSet)itr.next());
                    }
                    this.localBuffer.flush();
                    return null;
                }
            }
        }
    }
}

