/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Iterator;

public class ASTConstructOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        ProjectionNode projection;
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        switch (queryRoot.getQueryType()) {
            case CONSTRUCT: {
                break;
            }
            default: {
                if (context.nativeDistinctSPO) {
                    queryRoot.setProperty("nativeDistinct", true);
                }
                return new QueryNodeWithBindingSet(queryRoot, bindingSets);
            }
        }
        ConstructNode constructNode = queryRoot.getConstruct();
        if (constructNode == null) {
            throw new RuntimeException("No CONSTRUCT clause?");
        }
        if (queryRoot.getProjection() == null) {
            projection = new ProjectionNode();
            queryRoot.setProjection(projection);
            if (context.constructDistinctSPO) {
                projection.setReduced(true);
            }
        } else {
            projection = queryRoot.getProjection();
        }
        Iterator<IVariable<?>> itr = BOpUtility.getSpannedVariables(constructNode);
        while (itr.hasNext()) {
            projection.addProjectionVar(new VarNode(itr.next().getName()));
        }
        if (context.nativeDistinctSPO) {
            constructNode.setNativeDistinct(true);
        }
        SliceNode slice = queryRoot.getSlice();
        OrderByNode orderBy = queryRoot.getOrderBy();
        if (slice == null) {
            if (orderBy != null) {
                queryRoot.setOrderBy(null);
            }
        } else if (slice != null) {
            SubqueryRoot subqueryRoot = new SubqueryRoot(QueryType.SELECT);
            subqueryRoot.setProjection((ProjectionNode)projection.clone());
            subqueryRoot.setWhereClause(queryRoot.getWhereClause());
            queryRoot.setWhereClause(new JoinGroupNode(subqueryRoot));
            subqueryRoot.setSlice(slice);
            queryRoot.setSlice(null);
            if (orderBy != null) {
                subqueryRoot.setOrderBy(orderBy);
                queryRoot.setOrderBy(null);
            }
        }
        return new QueryNodeWithBindingSet(queryRoot, bindingSets);
    }
}

