/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ASTWildcardProjectionOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot subqueryRoot : queryRoot.getNamedSubqueries()) {
                IStriterator itr = new Striterator(BOpUtility.postOrderIteratorWithAnnotations(subqueryRoot.getWhereClause())).addTypeFilter(QueryBase.class);
                while (itr.hasNext()) {
                    QueryBase queryBase = (QueryBase)itr.next();
                    this.rewriteProjection(sa, queryBase, null);
                }
                this.rewriteProjection(sa, subqueryRoot, null);
            }
        }
        if (queryRoot.getWhereClause() != null) {
            IStriterator itr = new Striterator(BOpUtility.postOrderIteratorWithAnnotations(queryRoot.getWhereClause())).addTypeFilter(QueryBase.class);
            while (itr.hasNext()) {
                QueryBase queryBase = (QueryBase)itr.next();
                this.rewriteProjection(sa, queryBase, null);
            }
        }
        this.rewriteProjection(sa, queryRoot, context.getSolutionSetStats().getUsedVars());
        return new QueryNodeWithBindingSet(queryRoot, bindingSets);
    }

    private void rewriteProjection(StaticAnalysis sa, QueryBase queryBase, Set<IVariable<?>> exogeneousVars) {
        ProjectionNode projection = queryBase.getProjection();
        if (projection != null && projection.isWildcard()) {
            GraphPatternGroup whereClause = queryBase.getWhereClause();
            ProjectionNode p2 = new ProjectionNode();
            queryBase.setProjection(p2);
            if (projection.isDistinct()) {
                p2.setDistinct(true);
            }
            if (projection.isReduced()) {
                p2.setReduced(true);
            }
            Set<IVariable<?>> varSet = sa.getSpannedVariables(whereClause, new LinkedHashSet());
            if (exogeneousVars != null) {
                varSet.addAll(exogeneousVars);
            }
            if (queryBase.getBindingsClause() != null) {
                BindingsClause bc = queryBase.getBindingsClause();
                varSet.addAll(bc.getDeclaredVariables());
            }
            for (IVariable<?> var : varSet) {
                if (((Var)var).isAnonymous()) continue;
                p2.addProjectionVar(new VarNode(var.getName()));
            }
        }
    }
}

