/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service.history;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sparql.ast.service.history.HistoryChangeRecord;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class HistoryIndexTupleSerializer
extends DefaultTupleSerializer<HistoryChangeRecord, HistoryChangeRecord> {
    private static final long serialVersionUID = -1L;
    private SPOKeyOrder keyOrder;
    private boolean sids;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public HistoryIndexTupleSerializer() {
    }

    public HistoryIndexTupleSerializer(SPOKeyOrder keyOrder, boolean sids) {
        this(keyOrder, sids, HistoryIndexTupleSerializer.getDefaultLeafKeysCoder(), HistoryIndexTupleSerializer.getDefaultValuesCoder());
    }

    public HistoryIndexTupleSerializer(SPOKeyOrder keyOrder, boolean sids, IRabaCoder leafKeySer, IRabaCoder leafValSer) {
        super(new ASCIIKeyBuilderFactory(), leafKeySer, leafValSer);
        this.keyOrder = keyOrder;
        this.sids = sids;
    }

    @Override
    public byte[] serializeKey(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof HistoryChangeRecord) {
            return this.serializeKey((HistoryChangeRecord)obj);
        }
        throw new UnsupportedOperationException();
    }

    public byte[] serializeKey(HistoryChangeRecord changeRecord) {
        IKeyBuilder keyBuilder = this.getKeyBuilder().reset();
        keyBuilder.append(changeRecord.getRevisionTime());
        this.keyOrder.appendKey(keyBuilder, changeRecord.getStatement());
        byte[] key = keyBuilder.getKey();
        return key;
    }

    @Override
    public byte[] serializeVal(HistoryChangeRecord changeRecord) {
        if (changeRecord == null) {
            throw new IllegalArgumentException();
        }
        ISPO spo = changeRecord.getStatement();
        boolean override = spo.isOverride();
        boolean userFlag = spo.getUserFlag();
        StatementEnum type = spo.getStatementType();
        byte lowNibble = (byte)(type.code() | (override ? 8 : 0) | (userFlag ? 4 : 0));
        byte highNibble = (byte)changeRecord.getChangeAction().ordinal();
        byte b = (byte)(0xFF & (highNibble << 4 | lowNibble));
        return new byte[]{b};
    }

    @Override
    public HistoryChangeRecord deserializeKey(ITuple tuple) {
        return this.deserialize(tuple);
    }

    @Override
    public HistoryChangeRecord deserialize(ITuple tuple) {
        ChangeAction changeAction;
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        byte[] key = tuple.getKeyBuffer().array();
        long revisionTimestamp = KeyBuilder.decodeLong(key, 0);
        SPO spo = this.keyOrder.decodeKey(key, 8);
        if ((tuple.flags() & 2) != 0) {
            byte b = tuple.getValueBuffer().array()[0];
            byte lowNibble = (byte)(0xFF & (b & 0xF));
            byte highNibble = (byte)(0xFF & b >> 4);
            byte code = lowNibble;
            StatementEnum type = StatementEnum.decode(code);
            spo.setStatementType(type);
            spo.setOverride(StatementEnum.isOverride(code));
            spo.setUserFlag(StatementEnum.isUserFlag(code));
            if (this.sids) {
                assert (this.keyOrder.getKeyArity() == 3);
                if (spo.isExplicit()) {
                    // empty if block
                }
            }
            changeAction = ChangeAction.values()[highNibble];
        } else {
            changeAction = null;
        }
        HistoryChangeRecord changeRecord = new HistoryChangeRecord(spo, changeAction, revisionTimestamp);
        return changeRecord;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.keyOrder = SPOKeyOrder.valueOf(in.readByte());
                this.sids = in.readByte() > 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        out.writeByte(this.keyOrder.index());
        out.writeByte(this.sids ? 1 : 0);
    }
}

