/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchContains;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.striterator.IChunkConverter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.lang.reflect.Array;
import java.util.Arrays;

public class BulkFilterConverter
implements IChunkConverter<ISPO, ISPO> {
    private final IIndex ndx;
    private final boolean present;
    private final SPOTupleSerializer tupleSer;

    public BulkFilterConverter(IIndex ndx, boolean present) {
        this.ndx = ndx;
        this.present = present;
        this.tupleSer = (SPOTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
    }

    public ISPO[] convert(IChunkedOrderedIterator<ISPO> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] chunk = (ISPO[])src.nextChunk();
        if (!this.tupleSer.getKeyOrder().equals(src.getKeyOrder())) {
            Arrays.sort(chunk, this.tupleSer.getKeyOrder().getComparator());
        }
        byte[][] keys = new byte[chunk.length][];
        for (int i = 0; i < chunk.length; ++i) {
            keys[i] = this.tupleSer.serializeKey(chunk[i]);
        }
        AbstractKeyArrayIndexProcedure.ResultBitBufferHandler resultHandler = new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(keys.length);
        this.ndx.submit(0, keys.length, keys, null, BatchContains.BatchContainsConstructor.INSTANCE, resultHandler);
        boolean[] contains = resultHandler.getResult().getResult();
        int chunkSize = chunk.length;
        int j = 0;
        for (int i = 0; i < chunk.length; ++i) {
            if (contains[i] == this.present) {
                chunk[j] = chunk[i];
                ++j;
                continue;
            }
            --chunkSize;
        }
        if (chunkSize == 0) {
            return new ISPO[0];
        }
        ISPO[] filtered = (ISPO[])Array.newInstance(chunk[0].getClass(), chunkSize);
        System.arraycopy(chunk, 0, filtered, 0, chunkSize);
        return filtered;
    }
}

