/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPORelation;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class JustificationRemover
implements Callable<Long> {
    protected static final Logger log = Logger.getLogger(JustificationRemover.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    final SPORelation db;
    final ISPO[] a;
    final int numStmts;
    final AtomicLong sortTime;
    final AtomicLong writeTime;

    public JustificationRemover(SPORelation db, ISPO[] stmts, int numStmts, boolean clone, AtomicLong sortTime, AtomicLong writeTime) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        if (clone) {
            this.a = new ISPO[numStmts];
            System.arraycopy(stmts, 0, this.a, 0, numStmts);
        } else {
            this.a = stmts;
        }
        this.numStmts = numStmts;
        this.sortTime = sortTime;
        this.writeTime = writeTime;
    }

    @Override
    public Long call() throws Exception {
        long begin = System.currentTimeMillis();
        IIndex ndx = this.db.getJustificationIndex();
        Arrays.sort(this.a, 0, this.numStmts, SPOKeyOrder.SPO.getComparator());
        long beginWrite = System.currentTimeMillis();
        this.sortTime.addAndGet(beginWrite - begin);
        IKeyBuilder keyBuilder = KeyBuilder.newInstance(this.db.getKeyArity() * 8);
        for (int i = 0; i < this.numStmts; ++i) {
            ISPO spo = this.a[i];
            keyBuilder.reset();
            spo.s().encode(keyBuilder);
            spo.p().encode(keyBuilder);
            spo.o().encode(keyBuilder);
            byte[] fromKey = keyBuilder.getKey();
            byte[] toKey = SuccessorUtil.successor((byte[])fromKey.clone());
            ITupleIterator itr = ndx.rangeIterator(fromKey, toKey, 0, 16, null);
            long n = 0L;
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
            if (!DEBUG) continue;
            log.debug((Object)("Removed " + n + " justifications for " + spo.toString()));
        }
        long endWrite = System.currentTimeMillis();
        this.writeTime.addAndGet(endWrite - beginWrite);
        return endWrite - begin;
    }
}

