/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class StatementWriter
implements Callable<Long> {
    protected static final Logger log = Logger.getLogger(StatementWriter.class);
    private final AbstractTripleStore database;
    private final AbstractTripleStore statementStore;
    private final boolean copyOnly;
    private final IChunkedOrderedIterator<ISPO> itr;
    public final AtomicLong nwritten;
    private final IChangeLog changeLog;

    public StatementWriter(AbstractTripleStore database, AbstractTripleStore statementStore, boolean copyOnly, IChunkedOrderedIterator<ISPO> itr, AtomicLong nwritten) {
        this(database, statementStore, copyOnly, itr, nwritten, null);
    }

    public StatementWriter(AbstractTripleStore database, AbstractTripleStore statementStore, boolean copyOnly, IChunkedOrderedIterator<ISPO> itr, AtomicLong nwritten, IChangeLog changeLog) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        if (statementStore == null) {
            throw new IllegalArgumentException();
        }
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        if (nwritten == null) {
            throw new IllegalArgumentException();
        }
        this.database = database;
        this.statementStore = statementStore;
        this.copyOnly = copyOnly;
        this.itr = itr;
        this.nwritten = nwritten;
        this.changeLog = changeLog;
    }

    @Override
    public Long call() throws Exception {
        long begin = System.currentTimeMillis();
        long n = this.changeLog == null ? this.database.addStatements(this.statementStore, this.copyOnly, this.itr, null) : com.bigdata.rdf.changesets.StatementWriter.addStatements(this.database, this.statementStore, this.copyOnly, null, this.itr, this.changeLog);
        this.nwritten.addAndGet(n);
        return System.currentTimeMillis() - begin;
    }
}

