/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.btree.BTree;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;

public abstract class AbstractLocalTripleStore
extends AbstractTripleStore {
    protected AbstractLocalTripleStore(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
    }

    public StringBuilder getLocalBTreeBytesWritten(StringBuilder sb) {
        long bytesPerRecord;
        long totalWritten;
        long bytesWritten;
        long leavesWritten;
        long nodesWritten;
        BTreeCounters btreeCounters;
        boolean first = true;
        for (String fqn : this.getLexiconRelation().getIndexNames()) {
            btreeCounters = ((BTree)this.getIndexManager().getIndex(fqn, 0L)).getBtreeCounters();
            nodesWritten = btreeCounters.getNodesWritten();
            leavesWritten = btreeCounters.getLeavesWritten();
            bytesWritten = btreeCounters.getBytesWritten();
            totalWritten = nodesWritten + leavesWritten;
            bytesPerRecord = totalWritten == 0L ? 0L : bytesWritten / (nodesWritten + leavesWritten);
            sb.append((first ? "" : ", ") + fqn + "{nodes=" + nodesWritten + ",leaves=" + leavesWritten + ", bytes=" + bytesWritten + ", averageBytesPerRecord=" + bytesPerRecord + "}");
            first = false;
        }
        for (String fqn : this.getSPORelation().getIndexNames()) {
            btreeCounters = ((BTree)this.getIndexManager().getIndex(fqn, 0L)).getBtreeCounters();
            nodesWritten = btreeCounters.getNodesWritten();
            leavesWritten = btreeCounters.getLeavesWritten();
            bytesWritten = btreeCounters.getBytesWritten();
            totalWritten = nodesWritten + leavesWritten;
            bytesPerRecord = totalWritten == 0L ? 0L : bytesWritten / (nodesWritten + leavesWritten);
            sb.append((first ? "" : ", ") + fqn + "{nodes=" + nodesWritten + ",leaves=" + leavesWritten + ", bytes=" + bytesWritten + ", averageBytesPerRecord=" + bytesPerRecord + "}");
            first = false;
        }
        return sb;
    }
}

