/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.vocab;

import com.bigdata.rdf.vocab.VocabularyDecl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class BaseVocabularyDecl
implements VocabularyDecl {
    private final URI[] uris;

    public BaseVocabularyDecl(Object ... uris) {
        if (uris == null) {
            this.uris = new URI[0];
        } else {
            this.uris = new URI[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                if (uris[i] instanceof URI) {
                    this.uris[i] = (URI)uris[i];
                    continue;
                }
                if (uris[i] instanceof String) {
                    this.uris[i] = new URIImpl((String)uris[i]);
                    continue;
                }
                throw new IllegalArgumentException("URIs or Strings only: " + uris[i]);
            }
        }
    }

    @Override
    public Iterator<URI> values() {
        return Collections.unmodifiableList(Arrays.asList(this.uris)).iterator();
    }
}

