/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.accesspath.IElementFilter;
import java.lang.reflect.Array;

public abstract class AbstractArrayBuffer<E>
implements IBuffer<E> {
    protected final int capacity;
    protected final Class cls;
    protected final IElementFilter<E> filter;
    protected int size;
    protected E[] buffer;
    private long counter = 0L;

    protected AbstractArrayBuffer(int capacity, Class cls, IElementFilter<E> filter) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.cls = cls;
        this.filter = filter;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected boolean accept(E e) {
        return this.filter == null || this.filter.isValid(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (this.accept(e)) {
            AbstractArrayBuffer abstractArrayBuffer = this;
            synchronized (abstractArrayBuffer) {
                if (this.buffer == null) {
                    this.buffer = (Object[])Array.newInstance(this.cls, this.capacity);
                } else if (this.size == this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.size++] = e;
            }
        }
    }

    @Override
    public synchronized long flush() {
        if (this.size > 0) {
            long nwritten = this.flush(this.size, this.buffer);
            this.counter += nwritten;
            this.clearBuffer();
        }
        return this.counter;
    }

    @Override
    public synchronized void reset() {
        this.clearBuffer();
        this.counter = 0L;
    }

    private void clearBuffer() {
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = null;
        }
        this.size = 0;
    }

    protected abstract long flush(int var1, E[] var2);
}

