/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ChunkConsumerIterator<E>
implements IChunkedOrderedIterator<E> {
    protected static final Logger log = Logger.getLogger(ChunkConsumerIterator.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final ICloseableIterator<E[]> src;
    private final IKeyOrder<E> keyOrder;
    private int lastIndex = -1;
    private E[] chunk = null;
    private long nchunks = 0L;
    private long nelements = 0L;

    public ChunkConsumerIterator(ICloseableIterator<E[]> src) {
        this(src, null);
    }

    public ChunkConsumerIterator(ICloseableIterator<E[]> src, IKeyOrder<E> keyOrder) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
        this.keyOrder = keyOrder;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    public boolean hasNext() {
        if (this.lastIndex != -1 && this.lastIndex + 1 < this.chunk.length) {
            return true;
        }
        if (DEBUG) {
            log.debug((Object)"Testing source iterator.");
        }
        return this.src.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lastIndex == -1 || this.lastIndex + 1 == this.chunk.length) {
            this.chunk = (Object[])this.src.next();
            this.lastIndex = -1;
            if (INFO) {
                log.info((Object)("read chunk from source iterator: nchunks=" + this.nchunks + ", size=" + this.chunk.length));
            }
        }
        E e = this.chunk[++this.lastIndex];
        ++this.nelements;
        if (DEBUG) {
            log.debug((Object)("lastIndex=" + this.lastIndex + ", chunk.length=" + this.chunk.length + ", #chunks=" + this.nchunks + ", #elements=" + this.nelements + ", e=" + e));
        }
        return e;
    }

    @Override
    public E[] nextChunk() {
        if (this.lastIndex == -1 || this.lastIndex + 1 == this.chunk.length) {
            Object[] a = (Object[])this.src.next();
            ++this.nchunks;
            this.nelements += (long)a.length;
            if (INFO) {
                log.info((Object)("read chunk from source iterator: nchunks=" + this.nchunks + ", size=" + a.length));
            }
            return a;
        }
        int index = this.lastIndex + 1;
        int remaining = this.chunk.length - index;
        Object[] a = (Object[])Array.newInstance(this.chunk.getClass().getComponentType(), remaining);
        System.arraycopy(this.chunk, index, a, 0, remaining);
        this.chunk = null;
        this.lastIndex = -1;
        ++this.nchunks;
        this.nelements += (long)remaining;
        if (INFO) {
            log.info((Object)("remainder chunk: nchunks=" + this.nchunks + ", size=" + remaining));
        }
        return a;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.src.close();
        this.chunk = null;
        if (INFO) {
            log.info((Object)("#chunks=" + this.nchunks + ", #elements=" + this.nelements));
        }
    }
}

