/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.relation.rule.IQueryOptions;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStarJoin;
import com.bigdata.relation.rule.QueryOptions;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class Rule<E>
implements IRule<E> {
    private static final long serialVersionUID = -3834383670300306143L;
    protected static final transient Logger log = Logger.getLogger(Rule.class);
    protected static final transient boolean INFO = log.isInfoEnabled();
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    private final String name;
    private final IPredicate head;
    private final IPredicate[] tail;
    private final IQueryOptions queryOptions;
    private final IConstraint[] constraints;
    private final IRuleTaskFactory taskFactory;
    private final IBindingSet constants;
    private final Set<IVariable> vars;
    private final Set<IVariable> requiredVars;

    protected static Var var(String name) {
        return Var.var(name);
    }

    @Override
    public final int getVariableCount() {
        return this.vars.size();
    }

    @Override
    public final Iterator<IVariable> getVariables() {
        return this.vars.iterator();
    }

    @Override
    public final int getRequiredVariableCount() {
        return this.requiredVars.size();
    }

    @Override
    public final Iterator<IVariable> getRequiredVariables() {
        return this.requiredVars.iterator();
    }

    @Override
    public final int getTailCount() {
        return this.tail.length;
    }

    @Override
    public final IPredicate getHead() {
        return this.head;
    }

    @Override
    public final Iterator<IPredicate> getTail() {
        return Arrays.asList(this.tail).iterator();
    }

    @Override
    public final IPredicate getTail(int index) {
        return this.tail[index];
    }

    @Override
    public final IQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public final int getConstraintCount() {
        return this.constraints == null ? 0 : this.constraints.length;
    }

    @Override
    public final IConstraint getConstraint(int index) {
        if (this.constraints == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.constraints[index];
    }

    @Override
    public final Iterator<IConstraint> getConstraints() {
        return Arrays.asList(this.constraints).iterator();
    }

    @Override
    public final IBindingSet getConstants() {
        return this.constants;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(IBindingSet bindingSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" : ");
        for (int i = 0; i < this.tail.length; ++i) {
            sb.append(this.tail[i].toString(bindingSet));
            if (i + 1 >= this.tail.length) continue;
            sb.append(", ");
        }
        sb.append(" -> ");
        if (this.head != null) {
            sb.append(this.head.toString(bindingSet));
        }
        if (!(this.constants instanceof EmptyBindingSet)) {
            sb.append(", where ");
            sb.append(this.constants);
        }
        if (this.queryOptions != null) {
            sb.append(", queryOptions=" + this.queryOptions);
        }
        return sb.toString();
    }

    public Rule(String name, IPredicate head, IPredicate[] tail, IConstraint[] constraints) {
        this(name, head, tail, QueryOptions.NONE, constraints, null, null);
    }

    public Rule(String name, IPredicate head, IPredicate[] tail, IQueryOptions queryOptions, IConstraint[] constraints) {
        this(name, head, tail, queryOptions, constraints, null, null, null);
    }

    public Rule(String name, IPredicate head, IPredicate[] tail, IQueryOptions queryOptions, IConstraint[] constraints, IBindingSet constants, IRuleTaskFactory taskFactory) {
        this(name, head, tail, queryOptions, constraints, null, taskFactory, null);
    }

    public Rule(String name, IPredicate head, IPredicate[] tail, IQueryOptions queryOptions, IConstraint[] constraints, IBindingSet constants, IRuleTaskFactory taskFactory, IVariable[] requiredVars) {
        int i;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (tail == null) {
            throw new IllegalArgumentException();
        }
        if (queryOptions == null) {
            throw new IllegalArgumentException();
        }
        if (constants == null) {
            constants = EmptyBindingSet.INSTANCE;
        }
        this.name = name;
        this.tail = tail;
        HashSet<IVariable> vars = new HashSet<IVariable>();
        for (i = 0; i < tail.length; ++i) {
            IPredicate pred = tail[i];
            if (pred == null) {
                throw new IllegalArgumentException();
            }
            int arity = pred.arity();
            for (int j = 0; j < arity; ++j) {
                IVariableOrConstant t = pred.get(j);
                if (!t.isVar()) continue;
                vars.add((IVariable)t);
            }
            if (!(pred instanceof IStarJoin)) continue;
            IStarJoin starJoin = (IStarJoin)pred;
            Iterator<IVariable> it = starJoin.getConstraintVariables();
            while (it.hasNext()) {
                IVariable v = it.next();
                vars.add(v);
            }
        }
        this.head = head;
        if (head != null) {
            if (head.getRelationCount() != 1) {
                throw new IllegalArgumentException("Expecting a single relation identifier for the head: head=" + head);
            }
            int arity = head.arity();
            for (int j = 0; j < arity; ++j) {
                IVariableOrConstant t = head.get(j);
                if (!t.isVar() || vars.contains((IVariable)t)) continue;
                throw new IllegalArgumentException("Variable not declared in the tail: " + t);
            }
        }
        this.vars = Collections.unmodifiableSet(vars);
        this.queryOptions = queryOptions;
        this.constraints = constraints;
        if (constraints != null) {
            for (i = 0; i < constraints.length; ++i) {
                assert (constraints[i] != null);
            }
        }
        this.constants = constants;
        this.taskFactory = taskFactory;
        HashSet<IVariable> s = new HashSet<IVariable>();
        if (requiredVars == null) {
            s.addAll(vars);
        } else {
            for (IVariable v : requiredVars) {
                s.add(v);
            }
        }
        this.requiredVars = Collections.unmodifiableSet(s);
    }

    @Override
    public IRule<E> specialize(IBindingSet bindingSet, IConstraint[] constraints) {
        return this.specialize(this.getName() + "'", bindingSet, constraints);
    }

    @Override
    public IRule<E> specialize(String name, IBindingSet bindingSet, IConstraint[] constraints) {
        IConstraint[] newConstraint;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        IPredicate newHead = this.head == null ? null : this.head.asBound(bindingSet);
        IPredicate[] newTail = this.bind(this.tail, bindingSet);
        if (constraints == null || constraints.length == 0) {
            newConstraint = this.constraints;
        } else if (this.constraints == null || this.constraints.length == 0) {
            newConstraint = constraints;
        } else {
            int len = constraints.length + this.constraints.length;
            newConstraint = new IConstraint[len];
            System.arraycopy(this.constraints, 0, newConstraint, 0, this.constraints.length);
            System.arraycopy(constraints, 0, newConstraint, this.constraints.length, constraints.length);
        }
        IRuleTaskFactory taskFactory = this.getTaskFactory();
        Rule<E> newRule = new Rule<E>(name, newHead, newTail, this.queryOptions, newConstraint, bindingSet, taskFactory, this.requiredVars.toArray(new IVariable[this.requiredVars.size()]));
        return newRule;
    }

    private IPredicate[] bind(IPredicate[] predicates, IBindingSet bindingSet) {
        IPredicate[] tmp = new IPredicate[predicates.length];
        for (int i = 0; i < predicates.length; ++i) {
            tmp[i] = predicates[i].asBound(bindingSet);
        }
        return tmp;
    }

    @Override
    public Set<IVariable<?>> getSharedVars(int index1, int index2) {
        if (index1 == index2) {
            throw new IllegalArgumentException();
        }
        return Rule.getSharedVars(this.tail[index1], this.tail[index2]);
    }

    public static Set<IVariable<?>> getSharedVars(IPredicate p1, IPredicate p2) {
        HashSet vars = new HashSet();
        int arity1 = p1.arity();
        int arity2 = p2.arity();
        for (int i = 0; i < arity1; ++i) {
            IVariableOrConstant avar = p1.get(i);
            if (avar.isConstant()) continue;
            for (int j = 0; j < arity2; ++j) {
                if (p2.get(j) != avar) continue;
                vars.add((Var)avar);
            }
        }
        return vars;
    }

    @Override
    public int getVariableCount(int index, IBindingSet bindingSet) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        IPredicate pred = this.tail[index];
        int arity = pred.arity();
        int nbound = 0;
        for (int j = 0; j < arity; ++j) {
            IVariableOrConstant t = pred.get(j);
            if (!t.isVar() || bindingSet.isBound((IVariable)t)) continue;
            ++nbound;
        }
        return nbound;
    }

    @Override
    public boolean isFullyBound(int index, IBindingSet bindingSet) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        IPredicate pred = this.tail[index];
        int arity = pred.arity();
        for (int j = 0; j < arity; ++j) {
            IVariableOrConstant t = pred.get(j);
            if (!t.isVar() || bindingSet.isBound((IVariable)t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullyBound(IBindingSet bindingSet) {
        for (int i = 0; i < this.tail.length; ++i) {
            if (this.isFullyBound(i, bindingSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConsistent(IBindingSet bindingSet) {
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.length; ++i) {
                IConstraint constraint = this.constraints[i];
                if (constraint.accept(bindingSet)) continue;
                if (DEBUG) {
                    log.debug((Object)("Rejected by " + constraint.getClass().getSimpleName() + "\n" + this.toString(bindingSet)));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDeclared(IVariable var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        return this.vars.contains(var);
    }

    @Override
    public IRuleTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    @Override
    public final boolean isRule() {
        return true;
    }
}

