/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.accesspath.AbstractArrayBuffer;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.ChunkedResolvingIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;

public abstract class AbstractSolutionBuffer<R>
extends AbstractArrayBuffer<ISolution<R>[]> {
    private final IMutableRelation<R> relation;

    protected IMutableRelation<R> getRelation() {
        return this.relation;
    }

    protected AbstractSolutionBuffer(int capacity, IMutableRelation<R> relation) {
        super(capacity, ISolution[].class, null);
        if (relation == null) {
            throw new IllegalArgumentException();
        }
        this.relation = relation;
    }

    protected final long flush(int n, ISolution<R>[][] a) {
        int m = 0;
        for (int i = 0; i < n; ++i) {
            m += a[i].length;
        }
        ISolution[] b = new ISolution[m];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            ISolution<R>[] tmp = a[i];
            System.arraycopy(tmp, 0, b, k, tmp.length);
            k += tmp.length;
        }
        ChunkedArrayIterator<ISolution<R>> itr = new ChunkedArrayIterator<ISolution<R>>(m, b, null);
        return this.flush(itr);
    }

    protected abstract long flush(IChunkedOrderedIterator<ISolution<R>> var1);

    public static class DeleteSolutionBuffer<E>
    extends AbstractSolutionBuffer<E> {
        public DeleteSolutionBuffer(int capacity, IMutableRelation<E> relation) {
            super(capacity, relation);
        }

        @Override
        protected long flush(IChunkedOrderedIterator<ISolution<E>> itr) {
            ChunkedResolvingIterator itr2 = new ChunkedResolvingIterator<E, ISolution<E>>(itr){

                @Override
                protected E resolve(ISolution<E> e) {
                    return e.get();
                }
            };
            return this.getRelation().delete(itr2);
        }
    }

    public static class InsertSolutionBuffer<E>
    extends AbstractSolutionBuffer<E> {
        public InsertSolutionBuffer(int capacity, IMutableRelation<E> relation) {
            super(capacity, relation);
        }

        @Override
        protected long flush(IChunkedOrderedIterator<ISolution<E>> itr) {
            ChunkedResolvingIterator itr2 = new ChunkedResolvingIterator<E, ISolution<E>>(itr){

                @Override
                protected E resolve(ISolution<E> e) {
                    return e.get();
                }
            };
            return this.getRelation().insert(itr2);
        }
    }
}

